/* wait.c - wait */

#include <conf.h>
#include <kernel.h>
#include <proc.h>
#include <q.h>
#include <sem.h>

/*------------------------------------------------------------------------
 * wait  --  make current process wait on a semaphore
 *------------------------------------------------------------------------
 */
SYSCALL	wait(sem)
	int	sem;
{
	ps_t	ps;
	register struct	sentry	*sptr;
	register struct	pentry	*pptr;

	disable(ps);
	if (isbadsem(sem) || (sptr= &semaph[sem])->sstate==SFREE) {
		restore(ps);
		return(SYSERR);
	}
#ifdef DEBUG
	kprintf("wait #%d (%s) value %d\n",
		sem, sptr->sname, sptr->semcnt - 1 );
#endif
	if (--(sptr->semcnt) < 0) {
		(pptr = &proctab[currpid])->pstate = PRWAIT;
		pptr->psem = sem;
		enqueue(currpid,sptr->sqtail);
		resched();
	}
#ifdef DEBUG
	kprintf("back from wait on #%d (%s) ps %x\n", 
		sem, sptr->sname, ps );
#endif
	restore(ps);
	return(OK);
}
