/* ttyoin.c - ttyoin */

#include <conf.h>
#include <kernel.h>
#include <slu.h>			/* before tty.h */
#include <tty.h>
#include <io.h>

/*------------------------------------------------------------------------
 *  ttyoin  --  lower-half tty device driver for output interrupts
 *------------------------------------------------------------------------
 */
INTPROC	ttyoin(iptr)
	register struct	tty   *iptr;
{
    	volatile register struct csr *cptr;
	int	ct;

	cptr = iptr->ioaddr;

	if (iptr->ehead	!= iptr->etail)	{
#ifdef DL11
		cptr->ctbuf = iptr->ebuff[iptr->etail++];
#endif
#ifdef DUART681
		if( iptr->port == 0 )
		    cptr->DU_TBA = iptr->ebuff[iptr->etail++];
		else
		    cptr->DU_TBB = iptr->ebuff[iptr->etail++];
#endif
		if (iptr->etail	>= EBUFLEN)
			iptr->etail = 0;
		return;
	}
	if (iptr->oheld) {			/* honor flow control	*/
#ifdef DL11
		cptr->ctstat = SLUDISABLE;
#endif
#ifdef DUART681
		DUART_DISABLE(cptr,iptr);
#endif
		return;
	} /* oheld */

	if ((ct=scount(iptr->osem)) < OBUFLEN) {
#ifdef DL11
		cptr->ctbuf = iptr->obuff[iptr->otail++];
#endif DL11
#ifdef DUART681
		if( iptr->port == 0 )
		    cptr->DU_TBA = iptr->obuff[iptr->otail++];
		else
		    cptr->DU_TBB = iptr->obuff[iptr->otail++];
#endif DUART681
		if (iptr->otail	>= OBUFLEN)
			iptr->otail = 0;
		if (ct > OBMINSP)
			signal(iptr->osem);
		else if	( ++(iptr->odsend) == OBMINSP) {
			iptr->odsend = 0;
			signaln(iptr->osem, OBMINSP);
		}
	}
	else {
#ifdef DL11
		cptr->ctstat = SLUDISABLE;
#endif DL11
#ifdef DUART681
		DUART_DISABLE(cptr,iptr);
#endif DUART681
	}
}
