/* proc.h - isbadpid */

/* process table declarations and defined constants			*/

#ifndef	NPROC				/* set the number of processes	*/
#define	NPROC		10		/*  allowed if not already done	*/
#endif

/* process state constants */

#define	PRCURR		'\01'		/* process is currently running	*/
#define	PRFREE		'\02'		/* process slot is free		*/
#define	PRREADY		'\03'		/* process is on ready queue	*/
#define	PRRECV		'\04'		/* process waiting for message	*/
#define	PRSLEEP		'\05'		/* process is sleeping		*/
#define	PRSUSP		'\06'		/* process is suspended		*/
#define	PRWAIT		'\07'		/* process is on semaphore queue*/

/* miscellaneous process definitions */

#ifdef PDP11
#define	PNREGS		9		/* size of saved register area	*/
					/* r0-r5, sp, pc, ps */
#define	PNMLEN		8		/* length of process "name"	*/
#endif

#ifdef MC68K
#define PNREGS		19		/* D0-D7, A0-A6, SSP, PC, PS, USP */
#define PNMLEN		16
#endif

#ifdef NS32K
#define PNREGS		14		/* r0-r7, sp, pc, ps, fp, usp, sb */
#define PNMLEN		16
#endif

#define	NULLPROC	0		/* id of the null process; it	*/
					/*  is always eligible to run	*/

#define	isbadpid(x)	(x<=0 || x>=NPROC)
#define MAXPRIO		MAXINT		/* budd */

/* process table entry */

struct	pentry	{
	char	pstate;			/* process state: PRCURR, etc.	*/
	int	pprio;			/* process priority		*/
	Word	pregs[PNREGS];		/* saved regs. 			*/
	short	psem;			/* semaphore if process waiting	*/
	short	pmsg;			/* message sent to this process	*/
	short	phasmsg;		/* nonzero iff pmsg is valid	*/
	Word	pbase;			/* base of run time stack	*/
	Word	pstklen;		/* stack length			*/
	Word	plimit;			/* lowest extent of stack	*/
	char	pname[PNMLEN];		/* process name			*/
	short	pargs;			/* initial number of arguments	*/
	Word	paddr;			/* initial code address		*/
};

extern	struct	pentry proctab[];
extern	int	numproc;		/* currently active processes	*/
extern	int	nextproc;		/* search point for free slot	*/
extern	int	currpid;		/* currently executing process	*/
