/* kernel.h - disable, enable, halt, restore, isodd */

/* Symbolic constants used throughout Xinu */

typedef	char		Bool;		/* Boolean type			*/
#define	FALSE		0		/* Boolean constants		*/
#define	TRUE		1
#define	NULL		(char *)0	/* Null pointer for linked lists*/
#define	SYSCALL		int		/* System call declaration	*/
#define	LOCAL		static		/* Local procedure declaration	*/
#define	INTPROC		int		/* Interrupt procedure  "	*/
#define	PROCESS		int		/* Process declaration		*/
#define	RESCHYES	1		/* tell	ready to reschedule	*/
#define	RESCHNO		0		/* tell	ready not to resch.	*/

#ifdef PDP11
typedef unsigned short	Word;
#define	MININT		0100000		/* minimum integer (-32768)	*/
#define	MAXINT		0077777		/* maximum integer		*/
#define	SP		6		/* reg.	6 is stack pointer	*/
#define	PC		7		/* reg.	7 is program counter	*/
#define	PS		8		/* proc. status	in 8th reg. loc	*/
typedef char		ps_t;
#define	DISABLE		0340		/* PS to disable interrupts	*/

#define	MINSTK		40		/* minimum process stack size	*/
#define	NULLSTK		300		/* process 0 stack size		*/
#define	INITSTK		200		/* initial process stack	*/

#endif

#ifdef MC68K
typedef unsigned long	Word;
#define MININT		0x40000000
#define MAXINT		0x3fffffff
#define FP		14		/* frame in a6 */
#define	SSP		15 		/* Supervisor stack pointer	*/
#define	PS		16
#define	PC		17
#define USP		18		/* User stack pointer		*/
typedef short		ps_t;
#define DISABLE		0x2700

#define	MINSTK		4096		/* minimum process stack size	*/
#define	NULLSTK		4096		/* process 0 stack size		*/
#define	INITSTK		4096		/* initial process stack	*/

#endif

#ifdef NS32K
typedef unsigned long	Word;
#define MININT		0x40000000
#define MAXINT		0x3fffffff
#define FP		11		/* frame in a6 */
#define	SSP		8 		/* Supervisor stack pointer	*/
#define	PS		10
#define	PC		9
#define USP		12		/* User stack pointer		*/
typedef short		ps_t;
#define DISABLE		0		/* IE not set! USER not set */

#define	MINSTK		4096		/* minimum process stack size	*/
#define	NULLSTK		4096		/* process 0 stack size		*/
#define	INITSTK		4096		/* initial process stack	*/

#endif

#define	OK		 1		/* returned when system	call ok	*/
#define	SYSERR		-1		/* returned when sys. call fails*/

/* initialization constants */

#define	INITARGC	1		/* initial process argc		*/
#define	INITPRIO	20		/* initial process priority	*/
#define	INITNAME	"main"		/* initial process name		*/
#define	INITRET		userret		/* processes return address	*/
#define	INITREG		0		/* initial register contents	*/

/* misc. utility inline	functions */

#define	isodd(x)	(01&(int)(x))

#ifdef PDP11
#define	INITPS		0		/* initial process PS		*/
#define	disable(ps)	asm("mfps ~ps");asm("mtps $0340")
#define	restore(ps)	asm("mtps ~ps")	/* restore interrupt status	*/
#define	enable()	asm("mtps $000")/* enable interrupts		*/
#define	pause()		asm("wait")	/* machine "wait for interr."	*/
#define	halt()		asm("halt")	/* machine halt	instruction	*/
#endif

#ifdef MC68K
#define INITPS		0x2000
#define disable(ps)	(ps = _disable())
/**
#define enable()	asm("movw #0x2000,sr")
#define pause()		asm("stop #0x2000")
**/
#endif

#ifdef NS32K				/* gcc and bruce's as32k */

#define INITPS		0x800		/* enabled, supervisor */

#define enable()	asm("bispsrw h'800")
#define disable(ps)	asm("sprw psr,%0\n\tbicpsrw h'800" : "=g" (ps))
#define restore(ps)	asm("lprw psr,%0" : : "g" (ps))
#define pause()		asm("wait")
#endif

extern	int	rdyhead, rdytail;
extern	int	preempt;
