/****************************************************************
 * duart681.h
 *
 * defines for xx681 dual asynch recvr/transmitter
 * mc68681/mc68692
 * sn68681/sn68692
 * sn2681 /sn2692
 * 
 *
 * sources;
 * motorola ADI-988, October 1983 (advance information)
 * signetics microprocessor data manual 1987
 * 
 */

# define DUART681

# ifdef MC68K
# define NREG 32			/* PB68010 does word access */
# define DU_REG(x)	du_bytes[((x)*2)+1] /* on odd bytes */
# endif

# ifdef NS32K
# define NREG 16			/* PC532 does bus sizing */
# define DU_REG(x)	du_bytes[(x)]
# endif

struct csr {
    char du_bytes[NREG];
};

/****************************************************************
 * register offsets
 */

# define DU_MR1A	DU_REG(0x00)	/* RW mode register a part 1 */
# define DU_MR2A	DU_REG(0x00)	/* RW mode register a part 2 */

# define DU_SRA		DU_REG(0x01)	/* RO status register a */
# define DU_CSRA	DU_REG(0x01)	/* WO clock status register a */

# define DU_TESTA	DU_REG(0x02)	/* NEVER READ REGISTER 2!! */
# define DU_CRA		DU_REG(0x02)	/* WO command register a */

# define DU_RBA		DU_REG(0x03)	/* RO reciever buffer a */
# define DU_TBA		DU_REG(0x03)	/* WO transmit buffer a */
/*
 */
# define DU_IPCR	DU_REG(0x04)	/* RO input port change register */
# define DU_ACR		DU_REG(0x04)	/* WO auxilary control register */

# define DU_ISR		DU_REG(0x05)	/* RO interrupt state register */
# define DU_IMR		DU_REG(0x05)	/* WO interrupt mask register */

# define DU_CMSB	DU_REG(0x06)	/* RO counter most sig bits */
# define DU_CLSB	DU_REG(0x07)	/* RO counter least sig bits */

# define DU_CTUR	DU_REG(0x06)	/* WO counter/timer upper register */
# define DU_CTLR	DU_REG(0x07)	/* WO counter/timer upper register */
/*
 */
# define DU_MR1B	DU_REG(0x08)	/* RW mode register b part 1 */
# define DU_MR2B	DU_REG(0x08)	/* RW mode register b part 2 */

# define DU_SRB		DU_REG(0x09)	/* RO status register b */
# define DU_CSRB	DU_REG(0x09)	/* WO clock status register b */

# define DU_TESTB	DU_REG(0x0a)	/* NEVER READ REGISTER 10!! */
# define DU_CRB		DU_REG(0x0a)	/* WO command register b */

# define DU_RBB		DU_REG(0x0b)	/* RO reciever buffer b */
# define DU_TBB		DU_REG(0x0b)	/* WO transmit buffer b */
/*
 */
# ifdef MC68K
# define DU_IVR		DU_REG(0x0c)	/* RW interrupt vector register */
# endif

# define DU_IP		DU_REG(0x0d)	/* RO input port (unlatched) */
# define DU_OPCR	DU_REG(0x0d)	/* WO output port config register */

# define DU_STARTC	DU_REG(0x0e)	/* RA start counter (addr. trigger) */
# define DU_STOPC	DU_REG(0x0f)	/* RA stop counter (addr trigger) */

# define DU_OPRS	DU_REG(0x0e)	/* WO WA? output port set */
# define DU_OPRC	DU_REG(0x0f)	/* WO WA? output port clear */

/****************************************************************/
/* interrupt masks for IMR and ISR */
# define DU_IN_INP	0x80		/* input ports */
# define DU_IN_BKB	0x40		/* break b change */
# define DU_IN_RXB	0x20		/* rx b ready/full */
# define DU_IN_TXB	0x10		/* tx b ready */

# define DU_IN_CTR	0x08		/* counter / timer */
# define DU_IN_BKA	0x04		/* break a change */
# define DU_IN_RXA	0x02		/* rx a ready/full */
# define DU_IN_TXA	0x01		/* tx a ready */

/****************************************************************/
/* bits in SRA and SRB */
# define DU_SR_BRK	0x80		/* break */
# define DU_SR_EFRAME	0x40		/* framming error */
# define DU_SR_EPAR	0x20		/* parity error */
# define DU_SR_EOVER	0x10		/* overrun error */
# define DU_SR_TXEMPTY	0x08		/* tx underrun error */
# define DU_SR_TXREADY	0x04		/* tx ready */
# define DU_SR_FFULL	0x02		/* rx fifo full */
# define DU_SR_RXREADY	0x01		/* rx ready */

/* error mask */
# define DU_SR_ERRMASK \
    (DU_SR_BRK|DU_SR_EFRAME|DU_SR_EPAR|DU_SR_EOVER|DU_SR_TXEMPTY|DU_SR_FFULL)

/****************************************************************/
/* bits in ACR */

# define DU_ACR_SET2	    0x80	/* baud rate set 2 */

# define DU_ACR_C_IP2	    0x00	/* counter, clock from IP2 */
# define DU_ACR_C_TXCA	    0x10	/* counter, tx A clock */
# define DU_ACR_C_TXCB	    0x20	/* counter, tx B clock */
# define DU_ACR_C_X_16	    0x30	/* counter, x1/clk div 16 */

# define DU_ACR_T_IP2       0x40	/* timer, IP2 */
# define DU_ACR_T_IP2_16    0x50	/* timer, IP2 div 16 */
# define DU_ACR_T_X	    0x60	/* timer, x1/clk */
# define DU_ACR_T_X_16	    0x70	/* timer, x1/clk div 16 */

# define DU_ACR_DIP3	0x08		/* delta IP3 /IRQ */
# define DU_ACR_DIP2	0x04		/* delta IP2 /IRQ */
# define DU_ACR_DIP1	0x02		/* delta IP1 /IRQ */
# define DU_ACR_DIP0	0x01		/* delta IP0 /IRQ */

/****************************************************************/
/* bits in CRA / CRB */

# define DU_CR_RCV_ENA	0x01
# define DU_CR_RCV_DIS	0x02

# define DU_CR_XMT_ENA	0x04
# define DU_CR_XMT_DIS	0x08

# define DU_CR_MSC_RMR	0x10		/* reset MR pointer */
# define DU_CR_MSC_RRCV	0x20		/* reset reciever */
# define DU_CR_MSC_RXMT	0x30		/* reset transmitter */
# define DU_CR_MSC_RERR	0x40		/* reset error status */
# define DU_CR_MSC_RBREAK 0x50		/* reset break change interrupt */
# define DU_CR_MSC_BBREAK 0x60		/* begin break */
# define DU_CR_MSC_EBREAK 0x70		/* end break */

/* extensions for xx692 (CMOS) */
# define DU_CR_MSC_RRTS	0x80		/* raise RTS */
# define DU_CR_MSC_LRTS	0x90		/* lower RTS */
# define DU_CR_MSC_TMODE 0xA0		/* timeout mode */
# define DU_CR_MSC_RTMODE 0xC0		/* reset timeout mode */
# define DU_CR_MSC_PDN	0xE0		/* power down */
# define DU_CR_MSC_PUP	0xF0		/* power up */

/****************************************************************/

/* per duart data */
struct duart681 {
    unsigned char duart_imr;		/* mask register (write only) */
    unsigned char duart_acr;		/* clock/control (write only) */
    struct tty *duart_tty[2];
};

extern struct duart681 duart681[];

# define DUART_ENABLE(_csr,_tty) (_csr)->DU_IMR = \
    ((_tty)->dptr->duart_imr |= ((_tty)->port == 0 ? DU_IN_TXA : DU_IN_TXB))

# define DUART_DISABLE(_csr,_tty) (_csr)->DU_IMR = \
    ((_tty)->dptr->duart_imr &= ((_tty)->port == 0 ? ~DU_IN_TXA : ~DU_IN_TXB))

/****************************************************************/

# define DUART_BR_SET1 \
    { 50, 110, 134, 200, 300, 600, 1200, 1050, 2400, 4800, 7200, 9600, 38400 }

# define DUART_BR_SET2 \
    { 75, 110, 134, 150, 300, 600, 1200, 2000, 2400, 4800, 1800, 9600, 19200 }

/****************************************************************/

# ifdef NS32K
/* PC532 IP assignments */

# define DU_ACR_DCDA DU_ACR_DIP3
# define DU_ACR_DCDB DU_ACR_DIP2
# define DU_ACR_CTSB DU_ACR_DIP1
# define DU_ACR_CTSA DU_ACR_DIP0

# endif
