/* Output processing for terminal driver
   Copyright (C) 1993, 1994 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Michael I. Bushnell.  */

#include "term.h"
#include <ctype.h>

inline void
poutput (int c)
{
  if ((c >= ' ') && (c < '\177'))
    output_psize++;
  else if (c == '\r')
    output_psize = 0;
  else if (c == '\t')
    output_psize += (output_psize + 8) % 8;
  else if (c == '\b')
    output_psize--;
  
  (*lowerhalf->transmit) (c);
}

void
output_character (int c)
{
  int oflag = termstate.c_oflag;
  
  /* One might think we should turn of INHDERASE here, but, no
     in U*x it is only turned off by echoed characters.  
     See echo_char in input.c.  */
  if (oflag & OPOST)
    {
      /* Characters we write specially */
      if ((oflag & ONLCR) && c == '\n')
	{
	  poutput ('\r');
	  poutput ('\n');
	}
      else if ((oflag & OXTABS) && c == '\t')
	{
	  poutput (' ');
	  while (output_psize % 8)
	    poutput (' ');
	}
      else if ((oflag & ONOEOT) && c == CHAR_EOT)
	;
      else if ((oflag & OTILDE) && c == '~')
	{
	  poutput ('\\');
	  poutput ('`');
	}
      else if ((oflag & OLCASE) && isalpha (c))
	{
	  if (isupper (c))
	    poutput ('\\');
	  else
	    c = toupper (c);
	  poutput (c);
	}
      else
	poutput (c);
    }
  else
    poutput (c);
}

/* Report the width of character C as printed by output_character. */
int
output_width (int c)
{
  int oflag = termstate.c_oflag;
  
  if (oflag & OPOST)
    {
      if ((oflag & OTILDE) && c == '~')
	return 2;
      if ((oflag & OLCASE) && isalpha (c) && isupper (c))
	return 2;
    }
  if ((c >= ' ') && (c < '\177'))
    return 1;
  return 0;
}

    
  
