/* 
   Copyright (C) 1994 Free Software Foundation

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#include "ports.h"
#include <assert.h>

void
ports_reallocate_port (void *arg)
{
  struct port_info *pi = arg;
  error_t err;
  
  _libports_hash_remove (pi);
  mach_port_mod_refs (mach_task_self (), pi->port_right, 
		      MACH_PORT_RIGHT_RECEIVE, -1);

  err = mach_port_allocate (mach_task_self (), MACH_PORT_RIGHT_RECEIVE,
			    &pi->port_right);
  assert (!err);

  spin_lock (&_ports_mscount_lock);
  if (pi->sendrights)
    {
      spin_lock (&_libports_portrefcntlock);
      pi->refcnt--;
      spin_unlock (&_libports_portrefcntlock);
      pi->sendrights = 0;
    }
  pi->mscount = 0;
  spin_unlock (&_ports_mscount_lock);

  _libports_hash_intern (pi);
  mach_port_move_member (mach_task_self (), pi->port_right, 
			 _libports_request_portset);
}

