/*
   Copyright (C) 1994 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Michael I. Bushnell.  */

#include "ports.h"
#include <mach/notify.h>

void
ports_no_senders (void *arg, mach_port_mscount_t mscount)
{
  mach_port_t old;
  int dealloc;
  struct port_info *pi = arg;
  
  spin_lock (&_ports_mscount_lock);
  /* mscounnt should never exceed pi->mscount, but in case we
     are being spoofed by the kernel, this will at least clean up. */
  if (mscount >= pi->mscount)
    {
      dealloc = 1;
      pi->sendrights = 0;
    }
  else
    {
      /* Request a new notification.  The sync value is because we might
	 have accounted for a new sender but not actually made the send
	 right yet.  */
      mach_port_request_notification (mach_task_self (), pi->port_right,
				      MACH_NOTIFY_NO_SENDERS, pi->mscount,
				      pi->port_right, 
				      MACH_MSG_TYPE_MAKE_SEND_ONCE, &old);
      if (old)
	mach_port_deallocate (mach_task_self (), old);
      dealloc = 0;
    }
  spin_unlock (&_ports_mscount_lock);
  
  if (dealloc)
    ports_done_with_port (pi);
}

  
