/* 
   Copyright (C) 1993, 1994 Free Software Foundation

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#include "ports.h"
#include <assert.h>

#define DEATH_TIMEOUT (1000 * 60 * 10) /* Ten minutes */

/* Wait for messages on all the ports created with ports_allocate_port;
   for each message call ports_demuxer.  */
void
ports_manage_port_operations_onethread ()
{
  error_t err;
  
  while (1)
    {
      err = mach_msg_server_timeout (ports_demuxer, 0, 
				     _libports_request_portset,
				     MACH_RCV_TIMEOUT, DEATH_TIMEOUT);
      if (err == MACH_RCV_TIMED_OUT)
	{
	  spin_lock (&_ports_count_lock);
	  ports_notice_idle (_ports_nhardports, _ports_nsoftports);
	  spin_unlock (&_ports_count_lock);
	}
    }
}

