/* 
   Copyright (C) 1993, 1994 Free Software Foundation

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#include "ports.h"
#include "port-hash.h"

void
_libports_hash_intern (struct port_info *pi)
{
  struct port_hash_elt **bucket = 
    &_libports_port_hash_buckets [pi->port_right % N_HASH_BUCKETS];
  struct port_hash_elt *elt = malloc (sizeof (struct port_hash_elt));
  
  elt->pi = pi;

  spin_lock (&_libports_hash_lock);
  elt->next = *bucket;
  *bucket = elt;
  if (elt->next)
    elt->next->prevp = &elt->next;
  elt->prevp = bucket;
  spin_unlock (&_libports_hash_lock);
}
