/*
   Copyright (C) 1994 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Michael I. Bushnell.  */

#include "ports.h"
#include <mach/notify.h>

spin_lock_t _ports_mscount_lock = SPIN_LOCK_INITIALIZER;

mach_port_t
ports_get_right (void *arg)
{
  struct port_info *pi = arg;
  mach_port_t foo;
  
  spin_lock (&_ports_mscount_lock);
  pi->mscount++;
  if (!pi->sendrights)
    {
      pi->sendrights = 1;
      spin_lock (&_libports_portrefcntlock);
      pi->refcnt++;
      spin_unlock (&_libports_portrefcntlock);
      mach_port_request_notification (mach_task_self (), pi->port_right,
				      MACH_NOTIFY_NO_SENDERS, 1, 
				      pi->port_right,
				      MACH_MSG_TYPE_MAKE_SEND_ONCE, &foo);
      if (foo != MACH_PORT_NULL)
	mach_port_deallocate (mach_task_self (), foo);
    }
  spin_unlock (&_ports_mscount_lock);
  return pi->port_right;
}

