/* 
   Copyright (C) 1993, 1994 Free Software Foundation

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#include "ports.h"

/* Drop a user reference for port structure ARG.  */
void
ports_done_with_port (void *arg)
{
  struct port_info *pi = arg;
  
  if (!arg)
    return;

  spin_lock (&_libports_portrefcntlock);
  if (--pi->refcnt)
    {
      spin_unlock (&_libports_portrefcntlock);
      return;
    }
  spin_unlock (&_libports_portrefcntlock);

  if (ports_cleanroutines[pi->type])
    (*ports_cleanroutines[pi->type])(pi);
  if (*ports_generic_cleanroutine)
    (*ports_generic_cleanroutine)(pi);
  
  spin_lock (&_ports_count_lock);
  if (pi->soft)
    _ports_nsoftports--;
  else
    _ports_nhardports--;
  if (_ports_nsoftports == 0 && _ports_nhardports == 0)
    ports_no_live_ports ();
  else if (_ports_nhardports == 0)
    ports_no_hard_ports ();
  spin_unlock (&_ports_count_lock);

  _libports_hash_remove (pi);
  mach_port_mod_refs (mach_task_self (), pi->port_right, 
		      MACH_PORT_RIGHT_RECEIVE, -1);
  free (pi);
  return;
}

