/* 
   Copyright (C) 1993, 1994 Free Software Foundation

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#include "ports.h"

/* Look up port PORT; if it is of type TYPE, then allocate a new
   user reference for the associate port structure and return it;
   if it is not of type type, or was not created with ports_allocate_port,
   then return 0.  */
void *
ports_check_port_type (mach_port_t port, int type)
{
  struct port_info *pi;
  
  pi = _libports_hash_lookup (port);
  if (!pi || pi->type != type)
    return 0;
  
  spin_lock (&_libports_portrefcntlock);
  pi->refcnt++;
  spin_unlock (&_libports_portrefcntlock);
  return pi;
}


