/* 
   Copyright (C) 1994 Free Software Foundation

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#include "ports.h"

spin_lock_t _ports_count_lock = SPIN_LOCK_INITIALIZER;

/* Change the soft bit of port PORT. */
void
ports_change_hardsoft (void *arg, int soft)
{
  struct port_info *pi = arg;
  
  soft = !!soft;
  
  spin_lock (&_ports_count_lock);
  if (pi->soft != soft)
    {
      if (pi->soft)
	{
	  _ports_nsoftports--;
	  _ports_nhardports++;
	}
      else
	{
	  _ports_nhardports--;
	  _ports_nsoftports++;
	}
      pi->soft = soft;
    }
  spin_unlock (&_ports_count_lock);
}
