/* port management library -- allocate a port
   Copyright (C) 1993, 1994 Free Software Foundation

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#include "ports.h"
#include <assert.h>

int _ports_nsoftports = 0;
int _ports_nhardports = 0;

/* Allocate and return a port info structure of size SIZE and type TYPE. */
void *
ports_allocate_port (size_t size, int type)
{
  struct port_info *pi;
  kern_return_t err;
  
  if (size < sizeof (struct port_info))
    size = sizeof (struct port_info);
  
  pi = malloc (size);
  err = mach_port_allocate (mach_task_self (), MACH_PORT_RIGHT_RECEIVE,
			    &pi->port_right);
  assert (!err);
  
  pi->type = type;
  pi->refcnt = 0;
  pi->mscount = 0;
  pi->sendrights = 0;

  spin_lock (&_ports_count_lock);
  pi->soft = 0;
  _ports_nhardports++;
  spin_unlock (&_ports_count_lock);

  _libports_hash_intern (pi);
  
  mach_port_move_member (mach_task_self (), pi->port_right, 
			 _libports_request_portset);
  
  return pi;
}

