/* Pager creation
   Copyright (C) 1994 Free Software Foundation

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#include "priv.h"

/* Create and return a new pager with user info UPI.  */
struct pager *
pager_create (struct user_pager_info *upi, 
	      boolean_t may_cache,
	      memory_object_copy_strategy_t copy_strategy)
{
  struct pager *p;
  
  p = ports_allocate_port (sizeof (struct pager), pager_port_type);
  
  p->upi = upi;
  p->pager_state = NOTINIT;
  mutex_init (&p->interlock);
  condition_init (&p->wakeup);
  p->lock_requests = 0;
  p->attribute_requests = 0;
  p->may_cache = may_cache;
  p->copy_strategy = copy_strategy;
  p->memobjcntl = MACH_PORT_NULL;
  p->memobjname = MACH_PORT_NULL;
  p->seqno = -1;
  p->noterm = 0;
  p->termwaiting = 0;
  p->waitingforseqno = 0;
  p->pagemap = 0;
  p->pagemapsize = 0;

  return p;
}

  
