/* 
   Copyright (C) 1994 Free Software Foundation

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#include "trans.h"
#include <assert.h>

/* Implement fshelp_set_control; see <hurd/fshelp.h> for the
   description of the arguments. */
void
fshelp_set_control (struct trans_link *link, mach_port_t cntl)
{
  assert (link->control == MACH_PORT_NULL);
  
  link->control = cntl;
  link->starting = 0;
  link->error = 0;
  
  spin_lock (&_fshelp_translistlock);
  link->next = _fshelp_translist;
  link->prevp = &_fshelp_translist;
  _fshelp_translist = link;
  if (link->next)
    link->next->prevp = &link->next;
  spin_unlock (&_fshelp_translistlock);
}
