/* 
   Copyright (C) 1994 Free Software Foundation

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#include "trans.h"
#include <hurd/fsys.h>

/* Implement fshelp_kill_translator.  See <hurd/fshelp.h> for the
   description of the arguments.  */
void
fshelp_kill_translator (struct trans_link *trans)
{
  if (trans->control)
    {
      spin_lock (&_fshelp_translistlock);
      *trans->prevp = trans->next;
      if (trans->next)
	trans->next->prevp = trans->prevp;
      spin_unlock (&_fshelp_translistlock);
  
      /* Don't force the issue, but make an attempt. */
      fsys_goaway (trans->control, FSYS_GOAWAY_NOWAIT);
    }
}
