/* Initialize a trans_link structure
   Copyright (C) 1994 Free Software Foundation

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#include "trans.h"

spin_lock_t _fshelp_translistlock = SPIN_LOCK_INITIALIZER;

/* Call this before calling any of the other translator linkage routines,
   normally from your main node initialization routine. */
void
fshelp_init_trans_link (struct trans_link *link)
{
  link->control = MACH_PORT_NULL;
  condition_init (&link->initwait);
  mutex_init (&link->lock);
  link->starting = 0;
  link->error = 0;
}

