/* 
   Copyright (C) 1994 Free Software Foundation

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#include "trans.h"

/* Implement fshelp_handle_fsys_startup.  See <hurd/fshelp.h> for the
   description of the arguments.  */
error_t
fshelp_handle_fsys_startup (void *portstruct, mach_port_t ctl,
			    mach_port_t *real,
			    mach_msg_type_name_t *realpoly)
{
  struct transboot *tb = portstruct;
  
  mutex_lock (&tb->link->lock);

  if (tb->link->control != MACH_PORT_NULL)
    {
      condition_broadcast (&tb->link->initwait);
      mutex_unlock (&tb->link->lock);
      return EBUSY;
    }
  
  tb->link->starting = 0;
  tb->link->control = ctl;
  condition_broadcast (&tb->link->initwait);
  *real = tb->node;
  *realpoly = MACH_MSG_TYPE_COPY_SEND;

  spin_lock (&_fshelp_translistlock);
  tb->link->next = _fshelp_translist;
  tb->link->prevp = &_fshelp_translist;
  _fshelp_translist = tb->link;
  if (tb->link->next)
    tb->link->next->prevp = &tb->link->next;
  spin_unlock (&_fshelp_translistlock);
  
  mutex_unlock (&tb->link->lock);
  return 0;
}


