/* Translator destruction top half
   Copyright (C) 1992, 1993, 1994 Free Software Foundation

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#include "priv.h"
#include <hurd/fsys.h>

/* Get rid of any translator running on the file NP; FLAGS
   (from the set FSYS_GOAWAY_*) describes details of shutting
   down the child filesystem.  NP->translator.lock must be held. */
void
diskfs_destroy_translator (struct node *np,
			   int flags)
{
  fsys_goaway (np->translator.control, flags);
  fshelp_translator_drop (&np->translator);
}
