/* 
   Copyright (C) 1994 Free Software Foundation

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Mach lacks a way to find out from the kernel what devices there
   are, so we have to know here.  Sigh. */

#include "devlist.h"

/* Created by examination of mach/i386at/conf.c in MK 84, as well
   as by examination of the individual drivers.  Argh.  */

struct mach_dev mach_dev_list[] = 
{
  {"kd", DEV_TYPE_TTY, 0, 0},
  {"time", DEV_TYPE_CLOCK, 0, 0},
  {"hd", DEV_TYPE_DISK, 1, 16},
  {"wd", DEV_TYPE_NET, 1, 0},
  {"com", DEV_TYPE_TTY, 1, 0},
  {"iopl", DEV_TYPE_NONE, 0, 0},
  {"console", DEV_TYPE_TTY, 0, 0},
  {"clock_priv", DEV_TYPE_CLOCK, 0, 0},
  {"clock", DEV_TYPE_CLOCK, 0, 0},
#if 0
  {"fd", DEV_TYPE_DISK, 1, 64},
  {"sd", DEV_TYPE_DISK, 1, 8},
  {"st", DEV_TYPE_TAPE, 1, 8},
  {"sc", DEV_TYPE_NONE, 1, 8},
  {"cd_audio", DEV_TYPE_NONE, 1, 8},
  {"wt", DEV_TYPE_TAPE, 0, 0}, /* ??? Where's the source, Luke? */
  {"pc", DEV_TYPE_NET, 1, 0},
  {"el", DEV_TYPE_NET, 1, 0},
  {"et", DEV_TYPE_NET, 1, 0},
  {"par", DEV_TYPE_NET, 1, 0},
  {"de", DEV_TYPE_NET, 1, 0},
  {"lpr", DEV_TYPE_TTY, 1, 0},
  {"blit", DEV_TYPE_HIRES, 1, 0},
  {"kbd", DEV_TYPE_NONE, 0, 0},
  {"mouse", DEV_TYPE_NONE, 1, 0},
  {"mc", DEV_TYPE_CLOCK, 1, 0},
  {"clockpit", DEV_TYPE_CLOCK, 1, 0},
#endif
};

int mach_dev_list_len = (sizeof (mach_dev_list) / sizeof (struct mach_dev));

