/* 
   Copyright (C) 1994 Free Software Foundation

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Until Mach provides a way to find out what the devices are
   attached to the kernel, we have to do it ourselves in a grody
   fashion.  This array is created by a machine dependent file 
   here. */

enum device_type
{
  /* Kernel device types (or would be, if Mach exported this info) */
 DEV_TYPE_NONE,			/* no particular type */
 DEV_TYPE_AUDIO,		/* ADC devices, see audio_status.h */
 DEV_TYPE_CLOCK,		/* Clocks, see clock_status.h */
 DEV_TYPE_DISK,			/* Disks, see disk_status.h */
 DEV_TYPE_NET,			/* Net interfaces, see net_status.h */
 DEV_TYPE_TAPE,			/* Magnetic tape, see tape_status.h */
 DEV_TYPE_TTY,			/* terminal lines, see tty_status.h */
 DEV_TYPE_HIRES,		/* Hi-res graphics displays */

 /* Device types we know about but the kernel doesn't */

 DEV_TYPE_NULL,			/* data sink, EOF */
 DEV_TYPE_ZERO,			/* data sink, source of `\0' */
 DEV_TYPE_CTTY,			/* control terminal magic hook */
 DEV_TYPE_FDDIR,		/* directory for fd magic hooks */
 DEV_TYPE_FD,			/* fd magic hook */

 /* From here on down currently unimplemented */

 DEV_TYPE_PTYMASTER,		/* master side of pty */
 DEV_TYPE_PTYSLAVE,		/* slave side of pty */

 /* These three do *not* have the meanings they have in Unix;
    they exist here so that people that schlep around in /vmunix
    will get useful information. */
 DEV_TYPE_DRUM,			/* swap area */
 DEV_TYPE_KMEM,			/* kernel VM */
 DEV_TYPE_MEM,			/* physical memory */
};

struct mach_dev
{
  /* Name of the first part of the device */
  char *name;

  /* Type of device from list above */
  enum device_type type;

  /* TRUE if this device supports minor device numbers */
  int minordevices;

  /* Number of partitions supported per minor device number */
  int npartitions;
} mach_dev_list[];
int mach_dev_list_len;


