#include <math.h>
#include "util.h"

extern double fabs(double);

static double r2p = 180.0/M_PI;

double angle(int x, int y){
    double p = atan2((double) y,(double)x) / M_PI;  /* -1 <- p <- 1 */
    p *= 180.0;
    if (p < 0) p = (-p + 180.0);
    return p;
    
}	       

double Epsilon = 0.0;	

int  fuzzy_equals(double x, double y){
    return( fabs(x - y) < Epsilon);
}
