#ifndef MVALLOC_H
#define MVALLOC_H

#include "gp.h"

/*
 * Copyright (C) 1991, 1992 by Chris Thewalt (thewalt@ce.berkeley.edu)
 *
 * Permission to use, copy, modify, and distribute this software 
 * for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * copyright notice and this permission notice appear in supporting
 * documentation.  This software is provided "as is" without express or
 * implied warranty.
 */


#define MV_CHAR     123
#define MV_SHORT    124
#define MV_INT      125
#define MV_LONG     126
#define MV_FLOAT    127
#define MV_DOUBLE   128
#define MV_VOIDP    129
#ifdef __STDC__ || __EXTENSIONS__

extern void           * MValloc(int eltype, int dimension, ...);
extern void            MVfree(void *mvobj);
extern int             MVdimension(void *mvobj);
extern long int            MVsize(void *mvobj, int dimension);
extern long int       * MVsizes(void *mvobj);
extern int             MVtype(void *mvobj);
extern int 	 	MVconform(void *, void *);
extern void 	       * MVmake(int, int, long int *);
extern void           * MVlike(void *);
extern void           * MV2dopeq(void *, void *, enum GP_OPS);
extern void           * MV2dop(void *, void *, enum GP_OPS);
extern void           * MVnormalise(void *);
extern void 		MVinit(void *, double);
extern void            MVshift(void *, int);
extern double          MVsumpart(void *, int x1, int x2, int y1, int y2);
extern void 	write_mvarray(void *, FILE*);
extern void *  read_mvarray(FILE *);

#else  /* not __STDC__ */
extern void           *MValloc();
extern void            MVfree();
extern int             MVdimension();
extern long int           MVsize();
extern int             MVtype();
extern int             MVconform();
extern void           *MVlike();
#endif /* not __STDC__ */

#endif /* not MVALLOC_H */



