
/*
 * Copyright (C) 1991, 1994 by Steve Cumming (stevec@geog.ubc.ca)
 *
 * Permission to use, copy, modify, and distribute this software 
 * for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * copyright notice and this permission notice appear in supporting
 * documentation.  This software is provided "as is" without express or
 * implied warranty.
 */


#ifndef MAP_LIB
#define MAP_LIB
#include <stdio.h>
#include "sys.h"


extern int Debug;

#define TRUE 1
#define FALSE 0

#define sign(x) ((x) >= 0 ? 1 : -1)

extern int Debug;

#define POOLSZ 256

extern char * save_str(char *);

#ifdef __TURBOC__
struct spool {
    int offset;
    struct spool far *nxt;
    struct spool far *prev;
    char pool[POOLSZ];
};
#else
struct spool {
    int offset;
    struct spool *nxt;
    struct spool *prev;
    char pool[POOLSZ];
};
#endif

extern void bcxhar(char *, int, char);
extern struct spool *spool;
#ifdef NOCOPY
extern void memcpy(char *, char *, unsigned int);
#endif 

extern void * xalloc(size_t, char *);
extern void * xrealloc(void *, size_t, char *);
extern void   xstrcat(char **, char *);
extern void   xstrncat(char **, char *, int);
extern char * xstrdup(char *, char *);

/*
  this is a non-standard bsearch, so the decl does not belong
  in search.h
*/

extern void * bfirst(void *, void *, size_t, size_t, int (*)(const void *, const void *));

#define Assert(x,y) if (!x) {error(y);abort();}


extern void error(char *);
extern void fatal(char *);

char * nxt_token(FILE *);
char * nth_token(FILE *, int);
int get_nxt_line(FILE *, char *);
FILE * get_file(char *, char *);

char * pushdir(char *);
void   popdir(char *);


#ifdef MALLOCDEBUG
void heapcheck(void);
#endif

#endif
