/*
 * Copyright (C) 1994 by Steve Cumming (stevec@geog.ubc.ca)
 *
 * Permission to use, copy, modify, and distribute this software 
 * for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * copyright notice and this permission notice appear in supporting
 * documentation.  This software is provided "as is" without express or
 * implied warranty.
 */

#ifndef ARRAY
#define ARRAY

#include "gp.h"
#ifdef MAP
#include "lists.h"
void 	       write_array_list(struct lcb *, struct lcb *, FILE *);
#endif

struct array {
    enum DATA_TYPES type;
    int    n;
    void * a;
    void (*free)(void *);
};

enum array_op_type {SCALAR_MULT, SCALAR_ADD};
    
struct array * new_array(enum DATA_TYPES,int);
void free_array(struct array *);

struct array * resize_array(struct array *, int);
struct array * promote_array(struct array *, enum DATA_TYPES);
struct array * copy_coerce_array(struct array *, enum DATA_TYPES);
void 	       init_array(struct array *, struct value *);
struct array * add_array(struct array *, struct array *);
struct array * cat_array(struct array *, struct array *);
struct array * append_array(struct array *, struct array *);
struct array * shift_array(struct array *, int);
struct array * divide_array(struct array *, struct array *);
void 	       zero_array(struct array *);
double	       sum_array(struct array *);
char 	     * array_to_string(struct array *);
struct array * read_array(enum DATA_TYPES , FILE *, int);
void   read_array_pair(struct array **, enum DATA_TYPES , struct array **, enum DATA_TYPES, FILE *);
void 	       write_array(struct array *, FILE *);
void 	       write_array_pair(struct array *, struct array *,  FILE *);
void 	       write_dist(struct array *, FILE *);
struct array * op_array(struct array *, enum GP_OPS, struct value *);
struct array * dup_array(struct array *);
void   sort_array_in_place(struct array *);
void	put_double_array(struct array *, int, double);
double	get_double_array(struct array *, int);

void   put_array_value(struct array *, int, struct value *);
void   get_array_value(struct array *, int, struct value *);
void   set_array_free(struct array *, void (*fcn)(void *));
void 	put_ptr_array(struct array *, int, void *);
void array_bounds(struct array *, double *, double *);

void subsample_arrays(double p, struct array *, struct array *, struct array **, struct array **);
void subsample_array(double p, struct array *, struct array **);
#endif ARRAY








