/*
 * search.c - C source for GNU CHESS
 *
 * Copyright (c) 1988,1989,1990 John Stanback Copyright (c) 1992 Free Software
 * Foundation
 *
 * This file is part of GNU CHESS.
 *
 * GNU Chess is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2, or (at your option) any later
 * version.
 *
 * GNU Chess is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * GNU Chess; see the file COPYING.  If not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "gnuchess.h"
#if !defined OLDTIME && defined HASGETTIMEOFDAY
double pow ();
#endif
short background = 0;
static short DepthBeyond;
unsigned short PrVar[MAXDEPTH];
extern signed char mvstr[5][7];
extern short recycle, ISZERO;
#if defined NULLMOVE || defined DEEPNULL
short null;			/* Null-move already made or not */
short no_null;
short PVari;		/* Is this the PV */
#endif
#ifdef DEBUG40
extern int whichway;
#endif
#ifdef DEBUG
  int xxxtmp;
  int tracetmp;
unsigned short DBLINE[MAXDEPTH];
struct leaf *dbptr;

#endif
short zwndw;
unsigned int TTadd = 1;
short start_stage;
short thrashing_tt; /* must we recycle slots at random. TomV */

short recycle;
int ooo;

#if ttblsz

#define CB(i) (unsigned char) ((color[2 * (i)] ? 0x80 : 0)\
	       | (board[2 * (i)] << 4)\
	       | (color[2 * (i) + 1] ? 0x8 : 0)\
	       | (board[2 * (i) + 1]))
inline
int
ProbeTTable (short side,
	     short depth,
	     short ply,
	     short *alpha,
	     short *beta,
	     short *score)

/*
 * Look for the current board position in the transposition table.
 */

{
  register struct hashentry *ptbl;
  register /*unsigned*/ short i = 0;	/*to match new type of rehash --tpm*/

  ptbl = &ttable[side][hashkey % ttblsize];
  while (true)
    {
      if (ptbl->depth == 0)
	return false;
      if (ptbl->hashbd == hashbd)
	break;
      if (++i > rehash)
	return false;
      ptbl++;
    }

  /* rehash max rehash times */
  PV = SwagHt = ptbl->mv;
  if ((ptbl->depth >= (short) depth))
    {
#ifdef HASHTEST
      for (i = 0; i < 32; i++)
	{
	  if (ptbl->bd[i] != CB (i))
	    {
#ifndef BAREBONES
	      HashCol++;
	      ShowMessage (CP[199]);	/*ttable collision detected*/
#endif
	      break;
	    }
	}
#endif /* HASHTEST */


#ifndef BAREBONES
      HashCnt++;
#endif
      if (ptbl->flags & truescore)
	{
	  *score = ptbl->score;
	  /* adjust *score so moves to mate is from root */
	  if (*score > 9000)
	    *score -= ply;
	  else if (*score < -9000)
	    *score += ply;
	  *beta = -20000;
	}
      else if (ptbl->flags & lowerbound)
	{
	  if (ptbl->score > *alpha)
	    *alpha = ptbl->score - 1;
	}
      return (true);
    }
  return (false);
}

inline
int
PutInTTable (short side,
	     short score,
	     short depth,
	     short ply,
	     short alpha,
	     short beta,
	     unsigned short mv)

/*
 * Store the current board position in the transposition table.
 */

{
  register struct hashentry *ptbl;
  register /*unsigned*/ short i = 0;	/*to match new type of rehash --tpm*/

  ptbl = &ttable[side][hashkey % ttblsize];
  while (true)
    {
      if (ptbl->depth == 0 || ptbl->hashbd == hashbd)
	break;
      if (++i > rehash)
	{
#ifndef BAREBONES
	  THashCol++;
#endif
	  ptbl += recycle;
	  break;
	}
      ptbl++;
    }

  TTadd++;
#ifndef BAREBONES
  HashAdd++;
#endif
  /* adjust score so moves to mate is from this ply */
  if (score > 9000)
    score += ply;
  else if (score < -9000)
    score -= ply;
  ptbl->hashbd = hashbd;
  ptbl->depth = (unsigned char) depth;
  ptbl->score = score;
  ptbl->mv = mv;
#ifdef DEBUG
  if (debuglevel & 32)
    {
      algbr (mv >> 8, mv & 0xff, 0);
      printf ("-add-> h=%lx d=%d s=%d p=%d a=%d b=%d %s\n", hashbd, depth, score, ply, alpha, beta, mvstr);
    }
#endif
  if (score > beta)
    {
      ptbl->flags = lowerbound;
      ptbl->score = beta + 1;
    }
  else
    ptbl->flags = truescore;

#ifdef HASHTEST
  for (i = 0; i < 32; i++)
    {
      ptbl->bd[i] = CB (i);
    }
#endif /* HASHTEST */
  return true;
}

#endif

#include "ataks.h"

#include "debug41.h"
/* ............    MOVE GENERATION & SEARCH ROUTINES    .............. */
inline
int
repetition ()

/*  Check for draw by threefold repetition.  */

{
  register short i, c, cnt;
  register short m;
  short b[64];

  cnt = c = 0;
  /* try to avoid work */
  if (GameCnt > Game50 + 4)
    {
#if defined(NOMEMSET) || defined(MSDOS)
      for (i = 0; i < 64; b[i++] = 0);
#else
      memset ((signed char *) b, (int)0, (int)sizeof (b));
#endif /* NOMEMSET */
      for (i = GameCnt; i >= Game50; i--)
	{
	  m = GameList[i].gmove;
	  /* does piece exist on diff board? */
	  if (b[m & 0x3f])
	    {
	      /* does diffs cancel out, piece back? */
	      if ((b[m >> 8] += b[m & 0x3f]) == 0)
		--c;
	      b[m & 0x3f] = 0;
	    }
	  else
	    {
	      /* create diff */
	      ++c;
	      /* does diff cancel out another diff? */
	      if (!(b[m >> 8] -= (b[m & 0x3f] = board[m & 0x3f] +
				  (color[m & 0x3f] << 8))))
		--c;;
	    }
	  /* if diff count is 0 we have a repetition */
	  if (c == 0)
	    if ((i ^ GameCnt) & 1)
	      cnt++;
	}
    }
  return cnt;
}

int plyscore, globalscore;
int
pick (short p1, short p2)

/*
 * Find the best move in the tree between indexes p1 and p2. Swap the best
 * move into the p1 element.
 *
 */
{
  register struct leaf *p, *q, *r, *k;
  register s0;
  struct leaf temp;

  k = p = &Tree[p1];
  q = &Tree[p2];
  s0 = p->score;
  for (r = p + 1; r <= q; r++)
    if ((r->score) > s0)
      {
	s0 = (r->score);
	p = r;
      }
  if (p != k)
    {
      temp = *p;
      *p = *k;
      *k = temp;
      return true;
    }
  return false;
}

#ifdef DEBUG
unsigned short trace[MAXDEPTH];
signed char traceline[256];
unsigned short tracelog[MAXDEPTH];
int tracen = 0;
int traceflag = 0;
int traceply = 0;
#endif
int bookflag = false;
int Jscore = 0;

static int TCcount, TCleft;
void
SelectMove (short side, short iop)


/*
 * Select a move by calling function search() at progressively deeper ply
 * until time is up or a mate or draw is reached. An alpha-beta window of
 * -Awindow to +Bwindow points is set around the score returned from the
 * previous iteration. If Sdepth != 0 then the program has correctly
 * predicted the opponents move and the search will start at a depth of
 * Sdepth+1 rather than a depth of 1.
 */

{
  static short i, tempb, tempc, tempsf, tempst, xside, rpt;
  static short alpha, beta, score;
  static struct GameRec *g;
  short InChkDummy;
  short start_score;
  unsigned int j;
#ifdef DEBUG

  if (debuglevel & (512 | 1024))
    {
      signed char b[32];
      short c1, c2, r1, r2;
      tracen = 0;
      traceflag = false;
      traceply = 0;
      tracelog[0] = 0;
      while (true)
	{
	  printf ("debug?");
	  gets (b);
	  if (b[0] == 'p')
	    traceply = atoi (&b[1]);
	  else if (b[0] == '\0')
	    break;
	  else
	    {
	      c1 = b[0] - 'a';
	      r1 = b[1] - '1';
	      c2 = b[2] - 'a';
	      r2 = b[3] - '1';
	      trace[++tracen] = (locn (r1, c1) << 8) | locn (r2, c2);
	    }
	  if (tracen == 0 && traceply > 0)
	    traceflag = true;
	}

    }
#endif

  flag.timeout = false;
  flag.back = false;
  flag.musttimeout = false;
  INCscore = 0;
  xside = side ^ 1;
  recycle = (GameCnt % rehash) - rehash;
  /* if background mode set to infinite */
  if (iop == 2)
    {
      ResponseTime = 9999999;
      background = true;
    }
  else
    {
      player = side;
      if (TCflag)
	{
	  TCcount = 0;
	  background = false;
	  if (TimeControl.moves[side] < 1)
	    TimeControl.moves[side] = 1;
	  /* special case time per move specified */
	  if (flag.onemove)
	    {
	      ResponseTime = TimeControl.clock[side] - 100;
	      TCleft = 0;
	    }
	  else
	    {
	      /* calculate avg time per move remaining */

	      ResponseTime = (TimeControl.clock[side]) / (((TimeControl.moves[side]) * 3)/2 + 1);
	      TCleft = (int) ResponseTime / 3;
	      ResponseTime += TCadd / 2;
	      if (TimeControl.moves[side] < 5)
		TCcount = MAXTCCOUNTX - 10;
	    }
	  if (ResponseTime < 101)
	    {
	      ResponseTime = 100;
	      TCcount = MAXTCCOUNTX - 10;
	    }
	  else if (ResponseTime < 200)
	    {
	      TCcount = MAXTCCOUNTX - 10;
	    }
	}
      else
	{
	  ResponseTime = MaxResponseTime;
	  TCleft = 0;
	  ElapsedTime (1);
	}
      if (TCleft)
	{
	  TCcount = ((int) ((TimeControl.clock[side] - ResponseTime)) / 2) / TCleft;
	  if (TCcount > MAXTCCOUNTX)
	    TCcount = 0;
	  else
	    TCcount = MAXTCCOUNTX - TCcount;
	}
      else
	TCcount = MAXTCCOUNTX;
    }

  ExtraTime = 0;
  ExaminePosition ();
stage= -1; /* Force init in UpdateWeights() */
  start_score= Tscore[0]= Tscore[1]= score=
    evaluate (side, 1, 1, 0, -9999, 9999, 0, &InChkDummy);
  start_stage= stage;
#ifdef QUIETBACKGROUND
  if (!background)
#endif /* QUIETBACKGROUND */
    ShowSidetoMove ();
#ifdef QUIETBACKGROUND
  if (!background)
#endif /* QUIETBACKGROUND */
    SearchStartStuff (side);
#ifdef HISTORY
#if (defined(NOMEMSET) || defined(MSDOS)) && !defined(__GNUC__)
  for (j = 0; j <= 32768; j++)
    history[j] = 0;
#else
  memset ((unsigned char *) history, 0, (unsigned long) sizeof (history));
#endif /* NOMEMSET */
#endif
  FROMsquare = TOsquare = -1;
  PV = 0;
  if (iop == 1)
    hint = 0;
  for (i = 0; i < MAXDEPTH; i++)
    PrVar[i] = killr0[i] = killr1[i] = killr2[i] = killr3[i] = 0;
  /* set initial window for search */
  alpha = score - ((computer == black) ? BAwindow : WAwindow);
  beta = score + ((computer == black) ? BBwindow : WBwindow);
  rpt = 0;
  TrPnt[1] = 0;
  root = &Tree[0];
  MoveList (side, 1);
  for (i = TrPnt[1]; i < TrPnt[2]; i++) pick (i, TrPnt[2] - 1);
  /* can I get a book move? */
  if (flag.regularstart && Book)
    {
      flag.timeout = bookflag = OpeningBook (&hint, side);
      if (TCflag && !flag.onemove)
	ResponseTime += ResponseTime;
    }
  /* zero stats for hash table */
  reminus = replus = 0;
  GenCnt = NodeCnt = ETnodes = EvalNodes = HashCnt = FHashAdd = HashAdd = FHashCnt = THashCol = HashCol = 0;
  globalscore = plyscore = score;
  Jscore = 0;
  zwndw = 20;
#include "debug4.h"
  /********************* main loop ********************************/
  Sdepth = (MaxSearchDepth < (MINDEPTH - 1)) ? MaxSearchDepth : (MINDEPTH - 1);
  while (!flag.timeout)
    {
      /* go down a level at a time */
      Sdepth++;
#if defined NULLMOVE || defined DEEPNULL
      null = 0;
      PVari = 1;
#endif
      DepthBeyond = Sdepth +
        ((Sdepth == 1) ? FBEYOND : flag.threat ? SBEYOND: TBEYOND);
      no_null= (emtl[xside] == 0 || emtl[side] == 0);

#ifndef BAREBONES
#ifdef QUIETBACKGROUND
      if (!background)
#endif /* QUIETBACKGROUND */
	ShowDepth (' ');
#endif
      root->score= Tscore[0]= Tscore[1]= start_score;
      /* search at this level returns score of PV */
      score = search (side, 1, Sdepth, 0, alpha, beta, PrVar, &rpt, QBLOCK, false);
      /* save PV as killer */
      for (i = 1; i <= Sdepth; i++) killr0[i] = PrVar[i];

      /* low search failure re-search with (-inf,score) limits  */
      if (score < alpha)
	{
#ifndef BAREBONES
	  reminus++;
#ifdef QUIETBACKGROUND
	  if (!background)
#endif /* QUIETBACKGROUND */
	    ShowDepth ('-');
#endif
	  if (TCflag && TCcount < MAXTCCOUNTR)
	    {
	      TCcount = MAXTCCOUNTR - 1;
	      ExtraTime += (8 * TCleft);
	    }

          root->score= Tscore[0]= Tscore[1]= start_score;
	  score = search (side, 1, Sdepth, 0, -9999, 9999, PrVar, &rpt,QBLOCK,false);
	}
      /* high search failure re-search with (score, +inf) limits */
      else if (score > beta && !(root->flags & exact))
	{
#ifndef BAREBONES
	  replus++;
#ifdef QUIETBACKGROUND
	  if (!background)
#endif /* QUIETBACKGROUND */
	    ShowDepth ('+');
#endif
          root->score= Tscore[0]= Tscore[1]= start_score;
	  score = search (side, 1, Sdepth, 0, -9999, 9999, PrVar, &rpt,QBLOCK,false);
	}
      /**************** out of search ********************************************/
      if (flag.musttimeout || Sdepth >= MaxSearchDepth)
	flag.timeout = true;

      else if (TCflag && (Sdepth > (MINDEPTH - 1)) && (TCcount < MAXTCCOUNTR))
	{
	  if (killr0[1] != PrVar[1] /* || Killr0[2] != PrVar[2] */ )
	    {
	      TCcount++;
	      ExtraTime += TCleft;
	    }
	  if ((abs (score - globalscore) / Sdepth) > ZDELTA)
	    {
	      TCcount++;
	      ExtraTime += TCleft;
	    }
	}
      if (score > (Jscore - zwndw) && score > (Tree[1].score + 250))
	ExtraTime = 0;
      ElapsedTime (2);
      if (root->flags & exact)
	flag.timeout = true;
      /*else if (Tree[1].score < -9000) flag.timeout = true;*/
#if defined OLDTIME || !defined HASGETTIMEOFDAY
      else if (!(Sdepth < MINDEPTH) && TCflag && ((4 * et) > (2 * ResponseTime + ExtraTime)))
	flag.timeout = true;
#else
      else if (!(Sdepth < MINDEPTH) && TCflag &&
	       ((int) ((double)1.93913099l * (pow ((double) et, (double)1.12446928l))) > (ResponseTime + ExtraTime)))
	       { flag.timeout = true;}
#endif
      /************************ time control ***********************************/

      /* save PV as killer */
      for (i = 1; i <= Sdepth + 1; i++)
	killr0[i] = PrVar[i];
      if (!flag.timeout) start_score= Tscore[0] = score;
      /* if (!flag.timeout) */
      /* if done or nothing good to look at quit */
      if ((root->flags & exact) || (score < -9000))
	flag.timeout = true;
      /* find the next best move put below root */
#include "debug13.h"
      if (!flag.timeout)
	{
	  /* */
#if !defined NODYNALPHA
	  Jscore = (plyscore + score) >> 1;
#endif
	  zwndw = 20 + abs (Jscore / 12);
	  plyscore = score;
	  /* recompute search window */
	  beta = score + ((computer == black) ? BBwindow : WBwindow);
#if !defined NODYNALPHA
	  alpha = ((Jscore < score) ? Jscore : score) - ((computer == black) ? BAwindow : WAwindow) - zwndw;
#else
	  alpha = score - ((computer == black) ? BAwindow : WAwindow);
#endif
	}
#ifndef BAREBONES
#ifdef QUIETBACKGROUND
      if (!background)
#endif /* QUIETBACKGROUND */
	ShowResults (score, PrVar, '.');
#ifdef DEBUG41
      debug41 (score, PrVar, '.');
#endif
#endif
#include "debug16.h"
    }
  /******************************* end of main loop ***********************************/
  /* background mode */
  if (iop == 2)
    return;
#include "debug4.h"
  if (rpt >= 2)
    {
      root->flags |= draw;
      DRAW = CP[101];		/* Repetition */
    }
  else
    /* if no moves and not in check then draw */
  if ((score == -9999) && !(SqAtakd (PieceList[side][0], xside)))
    {
      root->flags |= draw;
      DRAW = CP[87];		/* No moves */
    }
  else if (GameCnt == MAXMOVES)
    {
      root->flags |= draw;
      DRAW = CP[80];		/* Max Moves */
    }
  /* not in book so set hint to guessed move for other side */
  if (!bookflag)
    hint = ((PrVar[1]) ? PrVar[2] : 0);

  /* if not mate or draw make move and output it */
  if (((score > -9999) && (rpt <= 2)) || (root->flags & draw))
    {
      MakeMove (side, &Tree[0], &tempb, &tempc, &tempsf, &tempst, &INCscore);
#if !defined NOMATERIAL
      if (flag.material && !pmtl[black] && !pmtl[white] && (mtl[white] < (valueR + valueK)) && (mtl[black] < (valueR + valueK)))
	{
	  root->flags |= draw;
	  DRAW = CP[224];	/* No pieces */
	}
      else
#endif
      if (!PieceCnt[black] && !PieceCnt[white])
	{
	  root->flags |= draw;
	  DRAW = CP[88];	/* No pieces */
	}
      algbr (root->f, root->t, (short) root->flags);
    }
  else
    {
      algbr (0, 0, 0);		/* Zero move string when mate. */
      root->score = score;	/* When mate, ignore distinctions!
				 * --SMC */
    }
  g = &GameList[GameCnt];
  if (g->flags & capture && g->piece == king)
    {
      flag.mate = flag.illegal = true;
    }
  /* If Time Control get the elapsed time */
  if (TCflag) ElapsedTime (1);
  /* if mate set flag */
  if ((score == -9999) || (score == 9999)) {flag.mate = true; 
#ifndef CLIENT
	flag.quit = true;
#endif
	}
  OutputMove ();
  /* if mate clear hint */
  if (flag.mate) hint = 0;
  /* if pawn move or capture or castle or promote zero repitition array */
  if ((board[root->t] == pawn) || (root->flags & (capture | cstlmask | promote)))
    {
      Game50 = GameCnt;
      ZeroRPT ();
    }
  /* add move to game list */
  g->score = score;
  g->nodes = NodeCnt;
  g->time = (et + 50) / 100;
/*
  g->time = TCcount;
*/
  g->depth = Sdepth;
#include "debug40.h"
  /* update time comtrol info */
  if (TCflag)
    {
#if defined CHESSTOOL || defined XBOARD
      TimeControl.clock[side] -= (et + OperatorTime + 45);
      timecomp[compptr] = (et + OperatorTime + 45);
#else
      TimeControl.clock[side] -= (et + OperatorTime);
      timecomp[compptr] = (et + OperatorTime);
#endif
      TimeControl.clock[side] += TCadd;
      /* finished our required moves - setup the next set */
      --TimeControl.moves[side];
    }
  /* check for end conditions */
  if ((root->flags & draw) /* && flag.bothsides */ )
#if !defined CLIENT
    flag.mate = true;
#else
    ;
#endif
  else if (GameCnt == MAXMOVES)
    {
      flag.mate = true;
    }
  /* out of move store, you loose */
  else
    /* switch to other side */
    player = xside;
  Sdepth = 0;
}


int
search (short side,
	register short ply,
	register short depth,
        short ext,
	short alpha,
	short beta,
	unsigned short *bstline,
	short *rpt,
	short SAVEHT,
	int didnull)

/*
 * Perform an alpha-beta search to determine the score for the current board
 * position. If depth <= 0 only capturing moves, pawn promotions and
 * responses to check are generated and searched, otherwise all moves are
 * processed. The search depth is modified for check evasions, certain
 * re-captures and threats. Extensions may continue for up to 11 ply beyond
 * the nominal search depth.
 */


{
  register short j, pnt;
  short tempb, tempc, tempsf, tempst;
  short xside, pbst, score, rcnt, slk, InChk;
  unsigned short mv, nxtline[MAXDEPTH];
  struct leaf *node, tmp;
  short best = -12000;
  short bestwidth = 0;
#if defined NULLMOVE || defined DEEPNULL
  short PVsave;
  short PVarisave;
  short verydeep= flag.verydeep;
  short nmoves;
#endif
  short extdb= 0;
  short threat= 0;      /* tom@izf.tno.nl */
  short threat2= 0;     /* tom@izf.tno.nl */
  short do_pvs;

  NodeCnt++;
  /* look every ZNODE nodes for a timeout */
#if defined NULLMOVE || defined DEEPNULL
  if (!null)
    {
#endif
      if (NodeCnt > ETnodes)
	{
	  ElapsedTime (2);
	  if (flag.back)
	    {
	      flag.back = false;
	      flag.timeout = true;
	      flag.musttimeout = false;
	    }
	  else if (TCflag || MaxResponseTime)
	    {
	      if ((et >= (ResponseTime + ExtraTime)) && Sdepth > MINDEPTH )
		{		/* try to extend to finish ply */
		  if (!flag.onemove && (flag.back || (TCflag && TCcount < MAXTCCOUNTX)))
		    {
		      flag.back = false;
		      flag.musttimeout = true;
		      TCcount += 1;
		      ExtraTime += TCleft;
		    }
		  else
		    {
		      flag.back = false;
		      flag.timeout = true;
		      flag.musttimeout = false;
		    }
		}
	    }
	  else if (flag.back)
	    {
	      flag.back = false;
	      flag.timeout = true;
	      flag.musttimeout = false;
	    }

	}
      else if (!TCflag && flag.musttimeout && Sdepth > MINDEPTH)
	{
	  flag.timeout = true;
	  flag.musttimeout = false;
	}
#if defined NULLMOVE || defined DEEPNULL
    }
#endif
  xside = side ^ 1;
  /* slk is lone king indicator for either side */
  if (ply == 1)
    INCscore= 0;
  score = evaluate (side, ply, depth, ext, alpha, beta, INCscore, &InChk);

  /*
   * check for possible repitition if so call repitition - rpt is
   * repeat count
   */
  if ((ply <= Sdepth + 3) && rpthash[side][hashkey & 0xFF] > 0)
    {
      *rpt = repetition ();

      /*
       * repeat position >2 don't need to return score it's taken
       * care of above
       */
      if (*rpt == 1)
	score /= 2;
    }
  else
    *rpt = 0;

  /* score > 9000 its a draw or mate */
  if (score > 9000 || root->flags & draw)
    {
      bstline[ply] = 0;
      return (score);
    }
  /* Do we need to add depth because of special conditions */
  /* if in check or pawn threat or in capture sequence search deeper */
  /*************************************** depth extensions ***********************************/
#ifdef OLDEXT
  if (depth > 0)
    {
      /* Allow opponent a chance to check again */
      if (InChk)
	depth = (depth < 2) ? 2 : depth;
      else if (PawnThreat[ply - 1] ||
	       (flag.rcptr && (score > alpha) &&
      (score < beta) && (ply > 2) && CptrFlag[ply - 1] && CptrFlag[ply - 2]))
	++depth;
    }
  else
    {
      if (score >= alpha &&
	  (InChk || PawnThreat[ply - 1] || (hung[side] > 1 /* && ply == Sdepth + 1*/)))
	depth = 1;
      else if (score <= beta &&
	       ((ply < Sdepth + 4) && (ply > 4) &&

		ChkFlag[ply - 2] && ChkFlag[ply - 4]))
	{
              depth = 1;
        }
    }
#else
 
#define DOTHREAT    (start_stage < THRSTAGE)
#define DOCHECK     (start_stage < CHECKSTAGE)
 
  Threat[ply]= 0;
  if (depth > 0)
    {
      /* Allow opponent a chance to check again */
      if (InChk) {
          if (flag.threat)
            depth= DOCHECK && (ply+depth<DepthBeyond-DEPTHMARGIN) ?
              depth+1: depth;
          else
            depth= (depth < 2) ? 2 : depth;
      }
      else if ((ply>1 && PawnThreat[ply - 1] && ply+depth<DepthBeyond-DEPTHMARGIN) ||                                        
               (flag.rcptr && ply>2 && CptrFlag[ply - 1] && CptrFlag[ply - 2] &&               ((ply<Sdepth+2 && CptrFlag[ply-1]==CptrFlag[ply-2]) ||
               (score > alpha && score < beta)))
               )
          ++depth;
    }
  else
    { 
      if (score >= alpha &&
          (InChk || (ply>1 && PawnThreat[ply - 1] && depth<DepthBeyond-4)
          || (hung[side] > 1 && !ext))) {
        threat2= 1;
        ext++;
        depth= 1;
      }
      else if (score <= beta &&
               ((ply<Sdepth+4 && ply>4 &&
                ChkFlag[ply-2] && ChkFlag[ply-4] &&
                (ChkFlag[ply-2] != ChkFlag[ply-4] ||
                (flag.threat && DOTHREAT && QueenCheck[ply-2])))
          ||
                (flag.threat && ply<DepthBeyond-DEPTHMARGIN && ply>6
                && ChkFlag[ply-2] && ChkFlag[ply-4] && ChkFlag[ply-6]
                && ((ply < Sdepth+4 ?
                  (ChkFlag[ply-2] != ChkFlag[ply-4] || ChkFlag[ply-2] != ChkFlag[ply-6])
                  : (ChkFlag[ply-2] != ChkFlag[ply-4] &&
                     ChkFlag[ply-2] != ChkFlag[ply-6] &&
                     ChkFlag[ply-4] != ChkFlag[ply-6]))
                || (DOTHREAT && QueenCheck[ply-2]
                && QueenCheck[ply-4] && QueenCheck[ply-6]
                && QueenCheck[ply-2] != QueenCheck[ply-6]))
                ))) {
          depth= 1;
          ext++;
          Threat[ply]= threat= 1;
        }
    }    
  ThreatSave[ply]= ((ply>1 && ThreatSave[ply-1]) || threat);
#endif
  /*******************************************************************************************/
  /* try the local transition table if it's there */
#if ttblsz
  if ( /*depth > 0 &&*/ flag.hash && ply > 1)
    {
      if (ProbeTTable (side, depth, ply, &alpha, &beta, &score) == true)
	{
	  bstline[ply] = PV;
	  bstline[ply + 1] = 0;
#include "debug64.h"
	  if (beta == -20000)
	    return (score);
	  if (alpha > beta)
	    return (alpha);
	}
#ifdef HASHFILE
      /* ok try the transition file if its there */
      else if (hashfile && (depth > HashDepth) && (GameCnt < HashMoveLimit)
	 && (ProbeFTable (side, depth, ply, &alpha, &beta, &score) == true))
	{
	      PutInTTable (side, score, depth, ply, alpha, beta, PV);
	      bstline[ply] = PV;
	      bstline[ply + 1] = 0;
	      if (beta == -20000)
		return (score);
	      if (alpha > beta)
		return (alpha);
#include "debug10.h"
	}
#endif /* HASHFILE */
    }
#endif /* ttblsz */
#if 1
  /* Make sure that width test at lower ply gets non random move
     count in case of pruning:  -- TomV
     This test also allows us to delay move generation till the
     null move is done.
   */
  if (ply>1)
    TrPnt[ply+1]= TrPnt[ply];
#endif


  /*
   * if more then DepthBeyond ply past goal depth or at goal depth and
   * score > beta quit - means we are out of the window
   */
  if (ply > DepthBeyond || (depth < 1 && score > beta))
    {
      return (score);
    }

  /*
   * if below first ply and not at goal depth generate all moves else
   * only capture moves
   */
  if (ply > 1)
    if (depth > 0 || (background && ply < Sdepth + 2))
      {
	MoveList (side, ply);
  	if (TrPnt[ply] == TrPnt[ply + 1]) { if(!InChk) return ((side==computer)?contempt:-contempt); else return (-10001+ply); }
      }
    else
      {
	CaptureList (side, ply);
	SAVEHT = false;
      }

  /* no moves return what we have */

  /*
   * normally a search will continue til past goal and no more capture
   * moves exist
   */
  /* unless it hits DepthBeyond */
  if (TrPnt[ply] == TrPnt[ply + 1]) { return (score); }



  /* if not at goal set best = -inf else current score */
  best = (depth > 0) ? -12000 : score;
#ifdef NULLMOVE

  PVarisave = PVari;
  if (!null &&			/* no previous null-move */
      !PVari &&			/* no null-move during the PV */
      (ply > 2) &&		/* not at ply 1 */
      (ply <= Sdepth) &&
      (depth > 3) &&
      !InChk &&			/* no check */
      ((mtl[side] + mtl[xside]) > NULLMOVELIM))
    /* enough material such that zugzwang is unlike but who knows which value
       is suitable? */
    {

      /* ok, we make a null move, i.e.  this means we have nothing to do
 	 but we have to keep the some arrays up to date otherwise gnuchess
 	 gets confused.  Maybe somebody knows exactly which informations are
	 important and which not.

	 Another idea is that we try the null-move first and generate the
	 moves later.  This may save time but we have to take care that
	 PV and other variables contain the right value so that the move
	 ordering works right.
	 */
      register struct GameRec *g;

      nxtline[ply + 1] = 0;
      CptrFlag[ply] = 0;
      PawnThreat[ply] = 0;
      Tscore[ply] = score;
      PVsave = PV;
      PV = 0;
      null = 1;
      g = &GameList[++GameCnt];
      g->hashkey = hashkey;
      g->hashbd = hashbd;
      epsquare = -1;
      TOsquare = -1;
      g->Game50 = Game50;
      g->gmove = -1;
      g->flags = 0;
      g->piece = 0;
      g->color = neutral;

      best = -search (xside, ply + 1, false, depth - 2, -beta - 1, -beta, nxtline, &rcnt,false,false);
      null = 0;
      PV = PVsave;
      GameCnt--;
	if (best < alpha) best = -12000;
      else if (best > 0 && best > beta) return (best);
      else best = -12000;
    }
#else if defined DEEPNULL

  /*
   * The deepnull algoritm is taken from the article by
   * Christian Donninger in ICCA journal Vol 16, No. 3.  TomV
   */
  PVarisave = PVari;
  if ((flag.deepnull ? !didnull : !null) &&	/* no previous null-move */
      !flag.nonull &&
      !no_null &&
      !PVari &&			/* no null-move during the PV */
      (ply > (flag.deepnull ? 1: 2)) &&		/* not at ply 1 */
      (score > alpha - 150 || !flag.deepnull) &&
      (ply <= Sdepth || flag.deepnull) &&
      (depth > (flag.deepnull ? (verydeep ? 1: 2): 3)) &&
      !InChk &&			/* no check */
      /* enough material such that zugzwang is unlikely: */
      ! (emtl[xside] == 0 || emtl[side] <= valueB))
    {

      /* ok, we make a null move, i.e.  this means we have nothing to do
 	 but we have to keep the some arrays up to date otherwise gnuchess
 	 gets confused.

	 Another idea is that we try the null-move first and generate the
	 moves later.  This may save time but we have to take care that
	 PV and other variables contain the right value so that the move
	 ordering works right.
	 */
      CptrFlag[ply] = 0;
      PawnThreat[ply] = 0;
      Tscore[ply] = score;
      PVsave = PV;
      PV = 0;
      epsquare = -1;
      TOsquare = -1;
      if (!null)
        null= ply;
      if (flag.deepnull) {
        int nmscore = -search (xside, ply + 1, (depth >= 3 ? depth - 3: 0), ext, -beta, -alpha, nxtline, &rcnt,false,1);
        if (ply == null)
          null = 0;
        PV = PVsave;
	if (nmscore > beta) {
	  DepthBeyond-= extdb;
	  return nmscore;
        }
	if (nmscore > alpha)
	  best= nmscore;
        if (depth <= 3 && ply < DepthBeyond-depth-4
            && score >= beta && nmscore < score - 350)
              depth++;
      } else {
        best = -search (xside, ply + 1, depth - 2, ext, -beta - 1, -beta, nxtline, &rcnt, false, 1);
        null = 0;
        PV = PVsave;
        if (best < alpha) best = -12000;
        else if (best > beta) {
	   DepthBeyond-= extdb;
           return (best);
        }  else best = -12000;
      }
    }
#endif
  /* if best so far is better than alpha set alpha to best */
  if (best > alpha) alpha = best;
  /********************** main loop ************************************************************************/
  /* look at each move until no more or beta cutoff */
  do_pvs = 0;
  for (pnt = pbst = TrPnt[ply]; pnt < TrPnt[ply + 1] && best <= beta; pnt++)
    {
      /* find the most interesting looking of the remaining moves */
      if (ply > 1)
	pick (pnt, TrPnt[ply + 1] - 1);
#ifdef NULLMOVE
      PVari = PVarisave && (pnt == pbst);	/* Is this the PV? */
#endif

      node = &Tree[pnt];
      if (pnt == pbst)
        do_pvs= flag.pvs && !null && (PrVar[ply] == ((node->f << 8) | node->t));


      /* is this a forbidden move */
      if (ply == 1 && node->score == -32768) continue;
#ifdef DEBUG
      if (debuglevel & (512 | 1024))
	{
	  if (!tracen)
	    traceflag = ((ply > traceply) ? false : true);
	  else if (ply <= tracen && (ply == 1 || traceflag))
	    {
	      if (trace[ply] == (Tree[pnt].t | (Tree[pnt].f << 8)))
		traceflag = true;
	      else
		traceflag = false;
	    }
	  tracelog[ply] = (Tree[pnt].t | (Tree[pnt].f << 8));
	  tracelog[ply + 1] = 0;
	}
#endif
      nxtline[ply + 1] = 0;

#ifndef BAREBONES
      /* if at top level */
      if (ply == 1)
	{			/* at the top update search status */
	  if (flag.post)
#ifdef QUIETBACKGROUND
	    if (!background)
#endif /* QUIETBACKGROUND */
	      ShowCurrentMove (pnt, node->f, node->t);
	}
#endif
	  /* make the move and go deeper */
	  MakeMove (side, node, &tempb, &tempc, &tempsf, &tempst, &INCscore);
	  CptrFlag[ply] = (node->flags & capture);
	  PawnThreat[ply] = (node->flags & pwnthrt);
	  Tscore[ply] = node->score;
	  PV = node->reply;
#ifdef DEBUG
	  xxxtmp = node->score;
	  tracetmp = traceflag;
#endif
	  if (do_pvs) {
            if (pbst == pnt) {
              node->score= -search (xside, ply + 1,
                                 depth > 0 ? depth - 1 : 0, ext,
                                 -beta, -alpha,
                                 nxtline, &rcnt,SAVEHT, 0);
            } else {
              node->score= -search(xside, ply + 1,
                              depth > 0 ? depth - 1 : 0, ext,
                              -alpha-1, -alpha,
                              nxtline, &rcnt,SAVEHT, 0);
              if (node->score >= best && alpha <= node->score
              && node->score <= beta)
                  node->score = -search (xside, ply + 1,
                                 depth > 0 ? depth - 1 : 0, ext,
                                 -beta, -node->score,
                                 nxtline, &rcnt,SAVEHT, 0);
            }
          } else

	  node->score = -search (xside, ply + 1,
				 (depth > 0) ? depth - 1 : 0, ext,
				 -beta, -alpha,
				 nxtline, &rcnt, SAVEHT, false);
	  node->width = (ply % 2 == 1) ? (TrPnt[ply + 2] - TrPnt[ply + 1]) : 0;
	  if (abs (node->score) > 9000) node->flags |= exact;
	  else if (rcnt == 1) node->score /= 2;
	  if(node->score == 9998 && !ChkFlag[ply] ) {node->flags |= draw;
	      node->score = ((side == computer) ? contempt : -contempt);}
#include "debug256.h"
	  if ((rcnt >= 2 || GameCnt - Game50 > 99 
/*|| (node->score == 9999 - ply && !ChkFlag[ply])*/
	      ))
	    {
	      node->flags |= (draw | exact);
	      DRAW = CP[58];	/* Draw */
	      node->score = ((side == computer) ? contempt : -contempt);
	    }
	  node->reply = nxtline[ply + 1];
	  /* reset to try next move */
	  UnmakeMove (side, node, &tempb, &tempc, &tempsf, &tempst);
      /* if best move so far */
      if (!flag.timeout && ((node->score > best) || ((node->score == best) && (node->width > bestwidth))))
	{
	  /*
	   * all things being equal pick the denser part of the
	   * tree
	   */
	  bestwidth = node->width;

	  /*
	   * if not at goal depth and better than alpha and not
	   * an exact score increment by depth
	   */
	  if (depth > 0 && node->score > alpha && !(node->flags & exact)) node->score += depth;
	  best = node->score;
	  pbst = pnt;
	  if (best > alpha) { alpha = best; }
	  /* update best line */
	  for (j = ply + 1; nxtline[j] > 0; j++) bstline[j] = nxtline[j]; 
	  bstline[j] = 0;
	  bstline[ply] = (node->f << 8) | node->t;
	  /* if at the top */
	  if (ply == 1)
	    {
	      /*
	       * if its better than the root score make it
	       * the root
	       */
	      if ((best > root->score) || ((best == root->score) && (bestwidth > root->width)))
		{
		  tmp = Tree[pnt];
		  for (j = pnt - 1; j >= 0; j--)
		    Tree[j + 1] = Tree[j];
		  Tree[0] = tmp;
		  pbst = 0;
		}
#ifndef BAREBONES
#ifdef QUIETBACKGROUND
	      if (!background)
#endif /* QUIETBACKGROUND */
		if (Sdepth > 2)
		  if (best > beta)
		    {
		      ShowResults (best, bstline, '+');
#ifdef DEBUG41
		      debug41 (best, bstline, '+');
#endif
		    }
		  else if (best < alpha)
		    {
		      ShowResults (best, bstline, '-');
#ifdef DEBUG41
		      debug41 (best, bstline, '-');
#endif
		    }
		  else
		    ShowResults (best, bstline, '&');
#ifdef DEBUG41
	      debug41 (best, bstline, '&');
#endif
#endif
	      if (!background && Sdepth > 2){
			 if( best < alpha ) { TCcount = 0;ExtraTime += 20*TCleft;}
                 }
	    }
	}
      if (flag.timeout)
	{
          DepthBeyond-= extdb;
#ifdef NULLMOVE
  PVari = PVarisave;
#endif
	  return (Tscore[ply - 1]);
	}
    }

  /******************************************************************************************/
  node = &Tree[pbst];
  mv = (node->f << 8) | node->t;
#ifdef NULLMOVE
  PVari = PVarisave;
#endif
#ifdef DEBUG
#include "debug512.h"
#endif

  /*
   * we have a move so put it in local table - if it's already there
   * done else if not there or needs to be updated also put it in
   * hashfile
   */
#if ttblsz
  if (SAVEHT && flag.hash && ply <= Sdepth && *rpt == 0 && best == alpha)
    {
      if (PutInTTable (side, best, depth, ply, alpha, beta, mv)
#ifdef HASHFILE
	  && hashfile && (depth > HashDepth) && (GameCnt < HashMoveLimit))
	{
	  PutInFTable (side, best, depth, ply, alpha, beta, node->f, node->t);
	}
#else
	);
#endif /* HASHFILE */
    }
#endif /* ttblsz */
  if (depth > 0)
    {
#ifdef HISTORY
      j = (node->f << 8) | node->t;
      if (side == black)
	j |= 0x4000;
      if (history[j] < HISTORYLIM)
	history[j] += (unsigned short) 1 << depth;
#endif
      if (node->t != (short) (GameList[GameCnt].gmove & 0xFF))
	if (best <= beta)
	  killr3[ply] = mv;
	else if (mv != killr1[ply])
	  {
	    killr2[ply] = killr1[ply];
	    killr1[ply] = mv;
	  }
      killr0[ply] = ((best > 9000) ? mv : 0);
    }
  return (best);
}




int
castle (short side, short kf, short kt, short iop)

/* Make or Unmake a castling move. */

{
  register short rf, rt, t0, xside;

  xside = side ^ 1;
  if (kt > kf)
    {
      rf = kf + 3;
      rt = kt - 1;
    }
  else
    {
      rf = kf - 4;
      rt = kt + 1;
    }
  if (iop == 0)
    {
      if (kf != kingP[side] ||
	  board[kf] != king ||
	  board[rf] != rook ||
	  color[kf] != side ||
	  color[rf] != side ||
	  Mvboard[kf] != 0 ||
	  Mvboard[rf] != 0 ||
	  color[kt] != neutral ||
	  color[rt] != neutral ||
	  color[kt - 1] != neutral ||
	  SqAtakd (kf, xside) ||
	  SqAtakd (kt, xside) ||
	  SqAtakd (rt, xside))
	return (false);
    }
  else
    {
      if (iop == 1)
	{
	  castld[side] = true;
	  Mvboard[kf]++;
	  Mvboard[rf]++;
	}
      else
	{
	  castld[side] = false;
	  Mvboard[kf]--;
	  Mvboard[rf]--;
	  t0 = kt;
	  kt = kf;
	  kf = t0;
	  t0 = rt;
	  rt = rf;
	  rf = t0;
	}
      board[kt] = king;
      color[rt] = color[kt] = side;
      Pindex[kt] = 0;
      board[kf] = no_piece;
      color[rf] = color[kf] = neutral;
      board[rt] = rook;
      Pindex[rt] = Pindex[rf];
      board[rf] = no_piece;
      PieceList[side][Pindex[kt]] = kt;
      PieceList[side][Pindex[rt]] = rt;
      UpdateHashbd (side, king, kf, kt);
      UpdateHashbd (side, rook, rf, rt);
    }
  return (true);
}


void
EnPassant (short xside, short f, short t, short iop)

/*
 * Make or unmake an en passant move.
 */

{
  register short l;

  l = t + ((t > f) ? -8 : 8);
  if (iop == 1)
    {
      board[l] = no_piece;
      color[l] = neutral;
    }
  else
    {
      board[l] = pawn;
      color[l] = xside;
    }
  InitializeStats ();
}


void
UpdatePieceList (short side, short sq, short iop,short piece)

/*
 * Update the PieceList and Pindex arrays when a piece is captured or when a
 * capture is unmade.
 */

{
  register short i;

  if (iop == 1)
    {
      PieceCnt[side]--;
      for (i = Pindex[sq]; i <= PieceCnt[side]; i++)
	{
	  PieceList[side][i] = PieceList[side][i + 1];
	  Pindex[PieceList[side][i]] = i;
	}
    }
  else
    { if(piece != king){
      PieceCnt[side]++;
      PieceList[side][PieceCnt[side]] = sq;
      Pindex[sq] = PieceCnt[side];
      } else {
	PieceCnt[side]++;
      	for (i = PieceCnt[side]; i > 0; i--)
        	{
          	PieceList[side][i] = PieceList[side][i - 1];
          	Pindex[PieceList[side][i]] = i;
        	} 
		PieceList[side][0] = sq;
		Pindex[sq] = 0;

      }
    }
}

void
MakeMove (short side,
	  struct leaf *node,
	  short *tempb,	/* color of to square */
	  short *tempc,	/* piece at to square */
	  short *tempsf,	/* static value of piece on from */
	  short *tempst,	/* static value of piece on to */
	  short *INCscore)	/* score increment for pawn structure change */

/*
 * Update Arrays board[], color[], and Pindex[] to reflect the new board
 * position obtained after making the move pointed to by node. Also update
 * miscellaneous stuff that changes when a move is made.
 */

{
  register short f, t, xside, ct, cf;
  register struct GameRec *g;

  xside = side ^ 1;
  g = &GameList[++GameCnt];
  g->hashkey = hashkey;
  g->hashbd = hashbd;
  g->epssq = epsquare;
  f = node->f;
  t = node->t;
  epsquare = -1;
  /* FROMsquare = f;*/
  TOsquare = t;
  *INCscore = 0;
  g->Game50 = Game50;
  g->gmove = (f << 8) | t;
  g->flags = node->flags;
  if (node->flags & cstlmask)
    {
      g->piece = no_piece;
      g->color = side;
      (void) castle (side, f, t, 1);
      Game50 = GameCnt;
    }
  else
    {
      if (!(node->flags & capture) && (board[f] != pawn))
	{
	  rpthash[side][hashkey & 0xFF]++;
	  ISZERO++;
	}
      else
	Game50 = GameCnt;
      *tempsf = svalue[f];
      *tempst = svalue[t];
      g->piece = *tempb = board[t];
      g->color = *tempc = color[t];
      if (*tempc != neutral)
	{
	  UpdatePieceList (*tempc, t, 1,*tempb);
	  /* if capture decrement pawn count */
	  if (*tempb == pawn)
	    {
	      --PawnCnt[*tempc][column (t)];
	    }
	  if (board[f] == pawn)
	    {
	      cf = column (f);
	      ct = column (t);
	      /* move count from from to to */
	      --PawnCnt[side][cf];
	      ++PawnCnt[side][ct];

	      /*
	       * calculate increment for pawn structure
	       * changes
	       */
	      /* doubled or more - */
	      if (PawnCnt[side][ct] > (1 + PawnCnt[side][cf]))
		*INCscore -= 15;
	      /* went to empty column + */
	      else if (PawnCnt[side][ct] < 1 + PawnCnt[side][cf])
		*INCscore += 15;

	      /*
	       * went to outside col or empty col on one
	       * side ????????
	       */
	      else if (ct == 0 || ct == 7 || PawnCnt[side][ct + ct - cf] == 0)
		*INCscore -= 15;
	    }
	  mtl[xside] -= value[*tempb];
	  if (*tempb == pawn)
	    pmtl[xside] -= valueP;
	  UpdateHashbd (xside, *tempb, -1, t);
	  *INCscore += *tempst;
	  Mvboard[t]++;
	}
      color[t] = color[f];
      board[t] = board[f];
      svalue[t] = svalue[f];
      Pindex[t] = Pindex[f];
      PieceList[side][Pindex[t]] = t;
      color[f] = neutral;
      board[f] = no_piece;
      if (board[t] == pawn)
	if (t - f == 16)
	  epsquare = f + 8;
	else if (f - t == 16)
	  epsquare = f - 8;
      if (node->flags & promote)
	{
	  board[t] = node->flags & pmask;
	  if (board[t] == queen)
	    HasQueen[side]++;
	  else if (board[t] == rook)
	    HasRook[side]++;
	  else if (board[t] == bishop)
	    HasBishop[side]++;
	  else if (board[t] == knight)
	    HasKnight[side]++;
	  --PawnCnt[side][column (t)];
	  mtl[side] += value[board[t]] - valueP;
	  pmtl[side] -= valueP;
	  UpdateHashbd (side, pawn, f, -1);
	  UpdateHashbd (side, board[t], f, -1);
	  *INCscore -= *tempsf;
	}
      if (node->flags & epmask)
	EnPassant (xside, f, t, 1);
      else
	UpdateHashbd (side, board[t], f, t);
      Mvboard[f]++;
    }
}

void
UnmakeMove (short side,
	    struct leaf *node,
	    short *tempb, /* -> piece */
	    short *tempc, /* -> side */
	    short *tempsf,
	    short *tempst)

/*
 * Take back a move.
 */

{
  register short f, t, xside;

  xside = side ^ 1;
  f = node->f;
  t = node->t;
  Game50 = GameList[GameCnt].Game50;
  if (node->flags & cstlmask)
    (void) castle (side, f, t, 2);
  else
    {
      color[f] = color[t];
      board[f] = board[t];
      svalue[f] = *tempsf;
      Pindex[f] = Pindex[t];
      PieceList[side][Pindex[f]] = f;
      color[t] = *tempc;
      board[t] = *tempb;
      svalue[t] = *tempst;
      if (node->flags & promote)
	{
	  board[f] = pawn;
	  ++PawnCnt[side][column (t)];
	  mtl[side] += valueP - value[node->flags & pmask];
	  pmtl[side] += valueP;
	  UpdateHashbd (side, (short) node->flags & pmask, -1, t);
	  UpdateHashbd (side, pawn, -1, t);
	}
      if (*tempc != neutral)
	{
	  UpdatePieceList (*tempc, t, 2,*tempb);
	  if (*tempb == pawn)
	    {
	      ++PawnCnt[*tempc][column (t)];
	    }
	  if (board[f] == pawn)
	    {
	      --PawnCnt[side][column (t)];
	      ++PawnCnt[side][column (f)];
	    }
	  mtl[xside] += value[*tempb];
	  if (*tempb == pawn)
	    pmtl[xside] += valueP;
	  UpdateHashbd (xside, *tempb, -1, t);
	  Mvboard[t]--;
	}
      if (node->flags & epmask)
	{
	  EnPassant (xside, f, t, 2);
	}
      else
	UpdateHashbd (side, board[f], f, t);
      Mvboard[f]--;
      if (!(node->flags & capture) && (board[f] != pawn))
	{
	  rpthash[side][hashkey & 0xFF]--;
	  ISZERO--;
	}
    }
  epsquare = GameList[GameCnt--].epssq;
}


void
InitializeStats (void)

/*
 * Scan thru the board seeing what's on each square. If a piece is found,
 * update the variables PieceCnt, PawnCnt, Pindex and PieceList. Also
 * determine the material for each side and set the hashkey and hashbd
 * variables to represent the current board position. Array
 * PieceList[side][indx] contains the location of all the pieces of either
 * side. Array Pindex[sq] contains the indx into PieceList for a given
 * square.
 */

{
  register short i, sq;

  epsquare = -1;
  for (i = 0; i < 8; i++)
    {
      PawnCnt[white][i] = PawnCnt[black][i] = 0;
    }
  mtl[white] = mtl[black] = pmtl[white] = pmtl[black] = 0;
  PieceCnt[white] = PieceCnt[black] = 0;
  hashbd = hashkey = 0;
  for (sq = 0; sq < 64; sq++)
    if (color[sq] != neutral)
      {
	mtl[color[sq]] += value[board[sq]];
	if (board[sq] == pawn)
	  {
	    pmtl[color[sq]] += valueP;
	    ++PawnCnt[color[sq]][column (sq)];
	  }
	Pindex[sq] = ((board[sq] == king) ? 0 : ++PieceCnt[color[sq]]);

	PieceList[color[sq]][Pindex[sq]] = sq;
	hashbd ^= hashcode[color[sq]][board[sq]][sq].bd;
	hashkey ^= hashcode[color[sq]][board[sq]][sq].key;
      }
}
