#!/bin/sh
# Delete a category from GNATS.
# Copyright (C) 1993 Free Software Foundation, Inc.
# Contributed by Brendan Kehoe (brendan@cygnus.com).
#
# This file is part of GNU GNATS.
#
# GNU GNATS is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# GNU GNATS is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU GNATS; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

GNATS_ROOT=@GNATS_ROOT@
GNATS_SITE=@GNATS_SITE@
LIBDIR=@LIBDIR@

if [ $# -eq 0 ]; then
  echo "usage: $0 category [category...]"
  exit 1
fi

if [ ! -d $GNATS_ROOT/gnats-dist ]; then
  echo "$0: No directory $GNATS_ROOT/gnats-dist!"
  exit 1
fi

if [ ! -d $LIBDIR/gnats ]; then
  echo "$0: $LIBDIR/gnats/$GNATS_SITE doesn't exist"
  exit 1
fi

for i in $*; do

    c=`grep "^$1:" $GNATS_ROOT/gnats-adm/categories`
    if [ "$c" != "" ]; then
      echo "$0: category $1 is still in the categories file, please remove it."
      continue
    fi
    if [ ! -d $GNATS_ROOT/$1 ]; then
      echo "$0: no directory for category $1"
      continue
    fi
    if [ "`ls $GNATS_ROOT/$1/*`" != "" ]; then
      echo "$0: bug reports are still in $1, remove them or recategorize them."
      continue
    fi
    echo Trying to delete $1...
    if rmdir $GNATS_ROOT/$1 ; then
      echo "$0: could not remove $GNATS_ROOT/$1"
      continue
    fi
    sed -e "/^$1$/D" $GNATS_ROOT/gnats-dist/categories > $GNATS_ROOT/gnats-dist/categories.tmp
    mv -f $GNATS_ROOT/gnats-dist/categories.tmp $GNATS_ROOT/gnats-dist/categories
    sed -e "/^$1$/D" $LIBDIR/gnats/$GNATS_SITE > $LIBDIR/gnats/$GNATS_SITE.tmp
    mv -f $LIBDIR/gnats/$GNATS_SITE.tmp $LIBDIR/gnats/$GNATS_SITE

done

exit 0
