.\" Copyright (c) 1993 Free Software Foundation, Inc.
.\" See section COPYING for conditions for redistribution
.TH queue-pr 8 "April 1993" "GNATS @VERSION@" "GNATS Administration Utilities"
.de BP
.sp
.ti -.2i
\(**
..
.SH NAME
queue-pr \- incoming mail control for
.B GNATS
.SH SYNOPSIS
.hy 0
.na
.TP 1i
.B queue-pr
[
.B \-q | \-\-queue
]
[
.B \-r | \-\-run
]
.br
[
.B \-f \fIfilename\fB | \-\-file=\fIfilename\fR
]
.br
[
.B \-d \fIdirectory\fB | \-\-directory=\fIdirectory\fR
]
.ad b
.hy 1
.SH DESCRIPTION
.B `queue-pr -q' 
should run through a 
.BR pipe (2V)
via the mail 
.BR aliases (5)
mechanism to automatically place incoming bug reports in a queue 
directory for
.B GNATS.
.LP
.B `queue-pr -r'
should be run via
.BR cron (8)
to periodically empty the 
.B GNATS
queue, filing new bug reports in the database.
.LP
One of [
.B \-q | \-\-queue
] or [
.B \-r | \-\-run
] (and not both) should be present upon each call to 
.B queue-pr.
These are separate functions in order to avoid collisions.
.SH OPTIONS
.TP 1i
.B \-q, \-\-queue
accepts standard input as an incoming mail file, placing this file in
the directory
.B @GNATS_ROOT@/gnats-queue
for future handling.
.TP
.B \-r, \-\-run
feeds all files from the directory
.B @GNATS_ROOT@/gnats-queue
to
.BR file-pr (8)
which files and creates index entries for each.
.TP
.B \-f \fIfilename\fR or \fB\-\-file=\fIfilename\fR
used with the
.B \-\-queue
option, treats
.I filename
rather than stdin as the input to use for an incoming file
.TP
.B \-d \fIdirectory\fR or \fB\-\-directory=\fIdirectory\fR
resets the default 
.I directory
value; when used with the 
.B \-\-queue
option, files incoming messages into 
.I directory
rather than 
.BR @GNATS_ROOT@/gnats-queue .
When used with the
.B \-\-run
option, operates on the files in 
.I directory
rather than 
.BR @GNATS_ROOT@/gnats-queue .
.SH FILES
.B @GNATS_ROOT@/gnats-queue
.SH "SEE ALSO"
.BR gnats.texi
and
.BR send-pr.texi ,
which are also installed as GNU
.B Info
files
.BR gnats.info
and 
.BR send-pr.info;
.LP
.BR gnats (l),
.BR send-pr (1),
.BR query-pr (1),
.BR edit-pr (1),
.BR file-pr (8),
.BR mkcat (8),
.BR rmcat (8),
.BR gen-index (8),
.BR mkdist (8).
.SH COPYING
Copyright (c) 1993 Free Software Foundation, Inc.
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
