.\" -*- nroff -*-
.\" ---------------------------------------------------------------------------
.\"    man page for GNATS (by Heinz G. Seidl, hgs@cygnus.com)
.\"    updated April 1993 for GNATS @VERSION@ by Jeffrey Osier, jeffrey@cygnus.com
.\"
.\"    This file is part of the GNU Problem Report Management System (GNATS)
.\"    Copyright 1993 Cygnus Support
.\"
.\"    This program is free software; you can redistribute it and/or
.\"    modify it under the terms of the GNU General Public
.\"    License as published by the Free Software Foundation; either
.\"    version 2 of the License, or (at your option) any later version.
.\"
.\"    This program is distributed in the hope that it will be useful,
.\"    but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
.\"    General Public License for more details.
.\"
.\"    You should have received a copy of the GNU Library General Public
.\"    License along with this program; if not, write to the Free
.\"    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA
.\"
.\" ---------------------------------------------------------------------------
.\" 
.TH GNATS l "April 1993" "GNATS @VERSION@" "Problem Report Management System"
.SH NAME
.B GNATS
\- Problem Report Management System
.SH DESCRIPTION
.B GNATS
is a bug-tracking tool designed for use at a central support site.
Software users who experience problems use electronic mail to
communicate these problems to the the maintainers of that software;
.B GNATS
partially automates the tracking of these problems by:
.TP
.B \(bu
organizing problem reports into a database and notifying responsible
parties of suspected bugs;
.TP
.B \(bu
allowing support personnel and their managers to edit, query and report
on accumulated bugs; and
.TP
.B \(bu
providing a reliable archive of problems with a given program and a
history of the life of the program by preserving its reported problems
and their subsequent solutions.
.LP
.B GNATS
offers many of the same features offered by more generic databases.
You can query and edit existing problem reports (\fIPR\fBs) as well as
obtain reports on groups of PRs.  The database itself is simply an
ordered repository for problem reports; each PR receives a unique,
incremental
.IR PR number ,
which identifies it throughout its lifetime.
.LP
Many of the primary functions available with 
.B GNATS
are accessible from within GNU 
.BR Emacs .
.SH "PROBLEM REPORT STATES"
PRs go through several defined states in their lifetimes.

.TP 2i
.I open
the initial state of every PR;
this means the PR has been filed and the person or group responsible
for it has been notified of the suspected problem
.TP
.I analyzed
the problem has been examined and work toward a solution has begun
.TP
.I feedback
a solution has been found and tested at the support site, and sent to
the party who reported the problem; that party is testing the solution
.TP
.I closed
the solution has been confirmed by the party which reported it
.LP
In some cases, it may be necessary to suspend work on a bug; in this
case, its state changes to
.I suspended
rather than 
.IR closed .
.SH STRUCTURE
Incoming PRs are assigned an incremental serial number and filed
according to category.  An index is kept concurrently to accelerate
searches of the database.
.LP
All 
.B GNATS
administration and database files are located in subdirectories of a
top-level directory signified with the variable 
.B GNATS_ROOT.
The directory has been set on this site to
.B @GNATS_ROOT@
and contains all
.I Problem Reports
segregated into subdirectories by category.  For example, problems
submitted with a category of
.I gcc
will be filed in the directory
.BR @GNATS_ROOT@/gcc .
.LP
.B GNATS
administration files are kept in
.BR @GNATS_ROOT@/gnats-adm :
.TP 1.5i
.B categories
table of valid categories and parties responsible for them
.TP
.B responsible
table of responsible parties and their email addresses
.TP
.B submitters
optional database of sites which submit PRs
.TP
.B current
keeps track of incremental PR numbers assigned; do not touch this file
.TP
.B index
database index which is managed internally; do not touch this file
.LP
Administrative programs and programs internal to
.B GNATS
are kept in the directory
.BR @GNATS_ROOT@/gnats-bin ,
while those meant for public use are installed in
.BR @PREFIX@/bin .
.LP
.B @GNATS_ROOT@/gnats-bin
contains the programs:
.TP 1.5i
.B mkcat
used by the
.B GNATS
administrator to create new categories
.TP
.B mkdist
used by the
.B GNATS
administrator to create a distribution of
.B send-pr
.TP
.B file-pr
main administrative program which files incoming PRs and controls the
index
.TP
.B queue-pr
mail control program which accepts incoming messages and periodically
submits them to the database via 
.B cron
by feeding them through the program
.BR file-pr (8)
.TP
.B at-pr
automatically notifies responsible parties if a PR is not analyzed
within a requisite period defined in the
.B submitters
file.
.LP
Programs intended for public use include:
.TP 1.5i
.B query-pr
used to query the database
.TP
.B edit-pr
used to edit individual PRs
.TP
.B send-pr
used to submit problems to 
.B GNATS
.LP
Documentation exists for all programs associated with
.B GNATS.
.SH "SEE ALSO"
.B gnats.texi
and
.BR send-pr.texi ,
which are also installed as GNU
.B Info
files
.B gnats.info
and 
.BR send-pr.info ;
.LP
.BR send-pr (1),
.BR query-pr (1),
.BR edit-pr (1),
.BR file-pr (8),
.BR queue-pr (8),
.BR mkcat (8),
.BR rmcat (8),
.BR gen-index (8),
.BR mkdist (8).
.SH HISTORY
.B GNATS 
was greatly inspired by the BSD 
.BR sendbug (1)
and
.BR bugfiler (8)
programs.  It was originally written in C++, Elisp, shell script, and
awk.  It presently consists of utilities written in C, shell script,
and Elisp.
.SH AUTHORS
.B GNATS
was originally written by Heinz G. Seidl (Cygnus Support).  Subsequent
iterations were developed by Brendan Kehoe (Cygnus Support), with help
from Tim Wicinski.  Documentation was developed by Jeffrey Osier
and Brendan Kehoe (Cygnus Support).
.SH COPYING
Copyright (c) 1992, 1993 Cygnus Support
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
