/* Define all procedures which are external to each other.
   Copyright (C) 1993 Free Software Foundation, Inc.
   Contributed by Tim Wicinski (wicinski@barn.com).

This file is part of GNU GNATS.

GNU GNATS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU GNATS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GNATS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _gnats_h_ 
#define _gnats_h_ 

/* Define these for the default settings */
#define PENDING "pending"

#include <ansidecl.h>

#include <stdio.h>

/* A generic boolean type.  */
typedef short bool;

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#include <sys/types.h>
#include <sys/stat.h>
#ifndef S_ISREG			/* Doesn't have POSIX.1 stat stuff. */
#define mode_t unsigned short
#endif
#if !defined(S_ISREG) && defined(S_IFREG)
#define	S_ISREG(m) (((m) & S_IFMT) == S_IFREG)
#endif
#ifndef S_ISLNK
#define lstat stat
#endif

#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#if defined(STDC_HEADERS) || defined(HAVE_STRING_H)
#include <string.h>
#ifndef index
#define index strchr
#endif
#ifndef rindex
#define rindex strrchr
#endif
#else
#include <strings.h>
char *memchr ();
#endif

#include <errno.h>
#ifdef STDC_HEADERS
#define getopt system_getopt
#include <stdlib.h>
#undef getopt
#else /* not STDC_HEADERS */
char *getenv ();
extern int errno;
#endif /* STDC_HEADERS */

#if defined(HAVE_FCNTL_H) || defined(_POSIX_VERSION)
#include <fcntl.h>
#else
#include <sys/file.h>
#endif

#ifndef SEEK_SET
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
#endif

#ifndef RETSIGTYPE
#define RETSIGTYPE void
#endif

/* Prototypes that are generic to all GNATS utilities.  */

#include "headers.h"
#include "pr.h"
#include "files.h"

/* Debugging level.  */
extern int debug_level;

/* File to log all messages to.  */
extern FILE *gnats_logfile;

/* Top of the GNATS tree.  */
extern char *gnats_root;

/* The program to be used to send the mail.  */
extern char *mail_agent;

/* Possible values for the logging mode.  Note "syslog" will only be used
   if the system supports it---otherwise it will relegate to "mail".  */
typedef enum
{
  SYSLOG,
  MAIL,
  STDERR,
  NUM_LOGGING_METHODS
} Logging_Methods;

/* Current logging method.  */
extern Logging_Methods log_method;


/* Used to keep track of each bad value for fields in a PR.  */
struct bad_enum
{
  char *msg;
  struct bad_enum *next;
};

/* Table to tell if a char c is whitespace.  */
extern unsigned char is_space[256];
#define SKIP_WHITE_SPACE(p) do { while (is_space[*p]) p++; } while (0)

/* in misc.c */
extern void init_gnats			PARAMS((void));
extern void log_msg			PARAMS((int, int, ...));
extern char *get_next_field		PARAMS((char *, char *, char));
extern int read_string			PARAMS((char *, FILE *));
extern void append_string		PARAMS((char **, char *));
extern char *get_token			PARAMS((char *, char *));
extern FILE *open_mail_file     	PARAMS((char *));
extern void init_space			PARAMS((void));
extern Responsible *get_responsible_address	PARAMS((char *));

/* in index.c */
extern FILE *open_index			PARAMS((void));
extern char *find_pr_category		PARAMS((FILE *, char *));
extern void create_index_entry		PARAMS((char *));
extern Index *next_index_entry		PARAMS((FILE *));
extern void close_index			PARAMS((FILE *));
extern Index *get_index			PARAMS((void));
extern void write_index			PARAMS((Index*));

/* in headers.c */
extern char *header_name		PARAMS((Header_Name));
extern char *header_value		PARAMS((Header_Name));
extern void set_header			PARAMS((Header_Name, char *));
extern void init_header			PARAMS((void));
extern void read_header			PARAMS((FILE *));
extern void write_header		PARAMS((FILE *, Header_Name));
extern FILE *open_mail_file		PARAMS((char *));
extern void close_mail_file		PARAMS((FILE *));

/* in pr.c */
extern void read_pr			PARAMS((FILE *, int));
extern void write_pr			PARAMS((FILE *, PR_Name));
extern void init_pr			PARAMS((void));
extern char *field_value		PARAMS((PR_Name));
extern bool set_field			PARAMS((PR_Name, char *));
extern struct bad_enum *check_enum_types	PARAMS((int));

#endif /* !_gnats_h_ */
