/* Global variable declarations. 
   Copyright (C) 1993 Free Software Foundation, Inc.
   Contributed by Tim Wicinski (wicinski@barn.com).

This file is part of GNU GNATS.

GNU GNATS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU GNATS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GNATS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _globals_h
#define _globals_h 1

#include <stdio.h>

/* Get `PARAMS'.  */
#include <ansidecl.h>

/* Include these so the prototypes will work correctly.  */
#include "pr.h"
#include "headers.h"
#include "files.h"

/* Name of this program.  */
extern char *program_name;

/* Whether or not to automatically create a directory for an unrecognized
   category.  Not used (yet).  */
extern int flag_autocreate;

/* If true, send the submitter an acknowledgement.  */
extern int flag_ack;

/* If true, don't send any notification.  */
extern int flag_notify;

/* Current version of GNATS.  */
extern char *version_string;

/* Head of linked list of responsible people. */
extern Responsible *responsible_chain;


/* These files are currently live under GNATS_ADM.  */

/* List of possible categories, with notification information.  */
#define CATEGORIES "/categories"

/* List of submitters (e.g., members of a team, sites on the net, customers,
   etc.) which can send in bug reports via send-pr.  */
#define SUBMITTERS "/submitters"

/* List of names (and possibly email addresses) for the different people
   responsible for a given PR.  `responsible' is somewhat of a misnomer, since
   the person responsible may well be a local user.  But the name stuck.  */
#define RESPONSIBLE_FILE  "/responsible"

/* File used to provide fast lookups on certain fields.  */
#define INDEX "/index"

/* Pathnames of GNATS-specific commands and tools.  */
#define BINDIR   "/gnats-bin"

/* Mailing program */
#ifndef BIN_MAIL
#define BIN_MAIL "/bin/mail"
#endif
#ifndef MAIL_AGENT
#define MAIL_AGENT "/usr/lib/sendmail -i -t"
#endif
#undef USE_BIN_MAIL

/* Address of the person to receive all problem reports which do not
   have a valid category (aka, they go into `pending'), or other related
   problems.  */
#define GNATS_ADMIN "gnats-admin"

#ifndef LOGGING 
# ifdef HAVE_SYSLOG_H
#  define LOGGING SYSLOG
#  ifndef LOG_LEVEL
#   ifdef LOG_USER
#    define LOG_LEVEL LOG_USER
extern int log_level;
#   endif
#  endif
# else /* !HAVE_SYSLOG_H */
/* FIXME */
#  define LOGGING MAIL
#  define LOG_ERR 0
#  define LOG_INFO 1
# endif /* HAVE_SYSLOG_H */
#endif /* LOGGING */

#define LOG_NONE -1

/* Default size of char arrays.  */
#define STR_MAX 255

/* Safely append a string.  */
#define APPEND_STRING(from, to, to_ptr, to_len, to_max, l, free_from)	\
 { if (from)							\
    {								\
      (l) = strlen (from);					\
      if ((to_len) + (l) > (to_max))				\
	{							\
	  (to_max) += BUFSIZ;					\
	  (to) = (char *) xrealloc ((to), (to_max));		\
	  (to_ptr) = (to) + (to_len);				\
	}							\
      memcpy ((to_ptr), (from), (l));				\
      (to_len) += (l);						\
      (to_ptr) += (l);						\
      if (free_from) free (from);				\
    }								\
 }

/* For struct tm.  */
#include <time.h>

/* In btime.c */
extern struct tm *get_response_time	PARAMS((int, char *));

/* in gnats.c */
extern void gnats			PARAMS((FILE *));
extern char *check_if_reply		PARAMS((FILE *));
extern void append_report		PARAMS((FILE *, char *));

/* in files.c */
extern int find_categories		PARAMS((Category*, char *));
extern int find_submitter		PARAMS((Submitter*, char *));
extern int init_responsibles		PARAMS((void));

/* in internal.c */
extern void block_signals               PARAMS((void));
extern void unblock_signals             PARAMS((void));
extern void add_to_index                PARAMS((void));
extern void lock_gnats                   PARAMS((void));
extern void unlock_gnats                 PARAMS((void));
extern void punt                        PARAMS((int, ...));
extern int copy_file                    PARAMS((char *, char *));

/* in resp_lookup.c */
extern Responsible* get_responsible		PARAMS((Category *));

/* in libiberty */
extern char *basename           	PARAMS((char *));
extern char *xmalloc			PARAMS((unsigned));
extern char *xrealloc			PARAMS((char *, unsigned));

#endif /* !_globals_h  */
