/* GNU Fortran
   Copyright (C) 1995 Free Software Foundation, Inc.
   Contributed by James Craig Burley (burley@gnu.ai.mit.edu).

This file is part of GNU Fortran.

GNU Fortran is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Fortran is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Fortran; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.	 */

#include "proj.h"
#include <ctype.h>
#include <signal.h>
#include "top.h"
#include "com.h"
#include "where.h"
#include "zzz.h"
#if FFECOM_targetCURRENT == FFECOM_targetGCC
#include "flags.j"
#endif

#define NAME_OF_STDIN "<stdin>"

#if FFECOM_targetCURRENT == FFECOM_targetFFE
void
main (int argc, char *argv[])
#else
#if FFECOM_targetCURRENT == FFECOM_targetGCC
FILE *finput;

int
yyparse ()
#endif
#endif
{
  ffewhereFile wf;

  if (ffe_is_version ())
    fprintf (stderr, "GNU Fortran Front End version %s compiled: %s %s\n",
	     ffezzz_version_string,
	     ffezzz_date,
	     ffezzz_time);

#if FFECOM_targetCURRENT == FFECOM_targetFFE
  ffe_init_0 ();

  for (--argc, ++argv; argc > 0; --argc, ++argv)
    {
      if (!ffe_decode_option (argv[0]))
	fprintf (stderr, "Unrecognized option: %s\n", argv[0]);
    }
#else
#if FFECOM_targetCURRENT == FFECOM_targetGCC
  ffe_set_is_pedantic (pedantic);
#endif
#endif

#if FFECOM_targetCURRENT == FFECOM_targetFFE
  wf = ffewhere_file_new (NAME_OF_STDIN, strlen (NAME_OF_STDIN));
  ffe_file (wf, stdin);
#else
#if FFECOM_targetCURRENT == FFECOM_targetGCC
  wf = ffewhere_file_new (main_input_filename, strlen (main_input_filename));
  ffe_file (wf, finput);
#endif
#endif

#if FFECOM_targetCURRENT == FFECOM_targetGCC
  ffecom_finish_compile ();

  return 0;
#else
  ffe_terminate_0 ();

  exit (0);
#endif
}
