/* proj.c file for GNU Fortran
   Copyright (C) 1995 Free Software Foundation, Inc.
   Contributed by James Craig Burley (burley@gnu.ai.mit.edu).

This file is part of GNU Fortran.

GNU Fortran is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Fortran is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Fortran; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.	 */

#include "proj.h"
#include <ctype.h>
#include "glimits.j"

#if NO_STRTOUL
unsigned long int
strtoul (char *nptr, char **endptr, int base)
{
  unsigned long int number = 0;
  unsigned long int old_number = 0;

  assert (base == 10);
  assert (endptr == NULL);

  while (isdigit (*nptr))
    {
      number = old_number * 10 + (*(nptr++) - '0');
      if ((number <= old_number) && (old_number != 0))
	return ULONG_MAX;
      old_number = number;
    }

  return number;
}

#endif

#if NO_BSEARCH
void *
bsearch (void *key, void *base, size_t nmemb, size_t size,
	 int (*compar) (void *, void *))
{
  size_t i;
  int cmp;

  /* We do a dumb incremental search, not a binary search, for now. */

  for (i = 0; i < nmemb; ++i)
    {
      if ((cmp = (*compar) (key, base)) == 0)
	return base;
      if (cmp < 0)
	break;
      base += size;
    }

  return NULL;
}

#endif
