;;
;; copyright (C) 1987, 1988 Franz Inc, Berkeley, Ca.
;;
;; The software, data and information contained herein are the property 
;; of Franz, Inc.  
;;
;; This file (or any derivation of it) may be distributed without 
;; further permission from Franz Inc. as long as:
;;
;;	* it is not part of a product for sale,
;;	* no charge is made for the distribution, other than a tape
;;	  fee, and
;;	* all copyright notices and this notice are preserved.
;;
;; If you have any comments or questions on this interface, please feel
;; free to contact Franz Inc. at
;;	Franz Inc.
;;	Attn: Kevin Layer
;;	1995 University Ave
;;	Suite 275
;;	Berkeley, CA 94704
;;	(415) 548-3600
;; or
;;	emacs-info%franz.uucp@Berkeley.EDU
;;	ucbvax!franz!emacs-info

;; $Header: ltags.el,v 1.7 88/08/11 21:25:13 layer Exp $

;; Description:
;; Emacs initiates the request for information in the Lisp environment,
;; namely the location of source files for Lisp symbols.  Emacs and Lisp
;; are talking through a Emacs buffer which is tied to a TCP/IP socket
;; (either a file or internet port), and there is an input filter running
;; on the Emacs side which interprets all information from Lisp.  This
;; process is, obviously, asynchronous.
;;

(defvar fi::tag-state nil
  "The last source info requested from cl.  This is used to implement
tags-loop-continue for lisp.")

(defun fi::lisp-find-tag-common (tag next other-window-p)
  ;; Find `tag' common code.  `tag' is nil if `next' is non-nil.
  (if next
      (fi:lisp-tags-loop-continue-common)
    (let* ((colonp (string-match ":?:" tag nil))
	   (sym (if colonp
		    (substring tag (match-end 0))
		  tag)))
      (if (and (fi::background-sublisp-process)
	       (not (string-match " " tag)))
	  (progn
	    (setq fi::tag-state nil)
	    (process-send-string
	     fi::backdoor-process
	     (format
	      "(format t \"%c~s\" (cons \"%s\" (source-file (find-symbol \"%s\" (find-package :%s)) t)))\n"
	      (if other-window-p 3 2)
	      sym sym (or fi:package "user"))))
	;; the backdoor-lisp-listener is not listening...
	(setq fi::tag-state nil)
	(fi::lisp-find-etag sym)))))

(defun fi::backdoor-find-tag-request (&optional other-window-p)
  ;; we get called when Lisp has an answer for the request initiated by
  ;; fi:lisp-find-tag
  (let* ((temp (get-buffer-create "*Lisp-to-Emacs*"))
	 (form (substring fi::sublisp-returns 1)))
    ;; first remove all #p's
    (save-excursion
      (set-buffer temp)
      (erase-buffer)
      (princ form temp)
      (beginning-of-buffer)
      (replace-string "#p" "")
      (setq form (car (read-from-string (buffer-string))))
      (kill-buffer temp))
    (setq fi::sublisp-returns "")
    (setq fi::tag-state form)
    ;; `form' is has one of the following forms:
    ;;   (tagname[string])
    ;;   (tagname[string] ((:type[symbol] . pathname[string]) ...))
    (if (cdr form)
	(fi::find-source-from-lisp-info
	 (car form) (car (cdr form)) other-window-p)
      (fi::lisp-find-etag (car form)))))

(defun fi::find-source-from-lisp-info (tagname info &optional other-window-p)
  ;; info is an alist of (type[symbol] . filename[string])
  (let* ((type (car info))
	 (file (cdr info))
	 (name tagname)
	 (search-form nil))
    (if (not (file-exists-p file))
	(error "Can't file source file: `%s'" file))
    (if other-window-p
	(find-file-other-window file)
      (find-file file))
    (beginning-of-buffer)
    (cond ((eq ':function type) (setq search-form "un"))
	  ((eq ':macro type) (setq search-form "macro"))
	  (t (setq search-form "\\(\\w\\)*")))
    (let ((start (string-match "::?" name))
	  (end (match-end 0)))
      (if start
	  (setq name
	    (format "\\(%s\\)*[:]*%s"
		    (substring name 0 start)
		    (substring name end))))
      (if (re-search-forward
	   (format "^(def%s %s" search-form name)
	   nil t)
	  (beginning-of-line)
	(message "couldn't find form in file")))))

(defun fi:lisp-tags-loop-continue-common ()
  ;; we get called to find the next tag
  (if (and fi::tag-state (cdr fi::tag-state))
      (let ((tagname (car fi::tag-state))
	    (info (cdr (cdr fi::tag-state))))
	(cond (info
	       (setq fi::tag-state (cons tagname info))
	       (fi::find-source-from-lisp-info tagname (car info) t))
	      (t (setq fi::tag-state (cons tagname nil))
		 (if (y-or-n-p
		      "no more source info from lisp, use tags file? ")
		     (progn
		       (setq last-tag tagname)
		       (find-tag nil t))))))
    (if fi::tag-state
	(setq last-tag (car fi::tag-state)))
    (find-tag nil t)))

(defun fi::lisp-find-etag (tag)
  (if fi:source-info-not-found-hook
      (funcall fi:source-info-not-found-hook tag)
    (message "The source location of `%s' is unknown." tag)))
