;;				-[Fri Nov 18 18:53:13 1988 by layer]-
;; Sample .emacs file
;;
;; $Header: dot.emacs,v 1.1 88/11/18 19:00:50 layer Exp $

(load "fi/site-init.el")

;; use a socket file in /tmp since can't communicate via files on NFS
;; mounted file systems
;;
(setq fi:unix-domain-socket
  (format "/tmp/%s_emacs_to_acl" (user-login-name)))

;; turn on superkeys in subprocess modes
;;
(setq-default fi:subprocess-enable-superkeys t)

;; the following causes fi:common-lisp to give the inferior Common
;; Lisp, by default, a command line argument of `+ipc':
;;
(setq fi:common-lisp-image-arguments '("+ipc"))

;; the following causes fi:common-lisp to invoke the image `acl', but
;; to ask for an image name when given a prefix argument:
;;
(setq fi:common-lisp-image-name
  '(lambda ()
    (let ((image "acl"))
      (if current-prefix-arg
	  (setq image
	    (read-file-name (format "cl image (default: %s): " image)
			    default-directory image nil)))
      (setq mode-line-buffer-identification
	(format "%s (%s)" (buffer-name) (file-name-nondirectory image)))
      image)))

;; This redefines `kill-emacs' so that transaction files in /tmp are
;; removed emacs is killed:
;;
(fset 'old-kill-emacs (symbol-function 'kill-emacs))
(defun kill-emacs (&optional arg)
  (interactive "P")
  (fi:remove-all-temporary-lisp-transaction-files)
  (old-kill-emacs arg))
