/*
 * Epoch 4.0 - Data structures for buttons and styles
 *
 * $Revision: 1.11 $
 * $Source: /import/kaplan/stable/distrib/epoch-4.0p1/src/RCS/button.h,v $
 * $Date: 92/01/29 15:42:54 $
 * $Author: love $
 */

struct Lisp_Button
{
  /* the first 2 fields are really the header of a vector.
   * the button code does not refer to them. buttons are
   * garbage collected along with vectors.
   */
  int size;
  struct Lisp_Vector *vec_next;
  /* next button in button list */
  Lisp_Object next;
  /* previous button in button list */
  Lisp_Object prev;
  /* marker to where the button begins */
  Lisp_Object start;
  /* marker to where the button ends */
  Lisp_Object end;
  /* button's style */
  Lisp_Object style;
  /* arbitrary data associated with the button */
  Lisp_Object data;
  /* flag - is button "read-only" */
  Lisp_Object read_only;
  /* flag - is button "transient" */
  Lisp_Object transient;
};

struct Lisp_Style
{
  /* another vector, see above */
  int size;
  struct Lisp_Vector *vec_next;

  /* The real structure elements -- these should all be X-resources, or nil */
  /* The colors, should be X-cardinals, with the pixel values in them */
  Lisp_Object foreground;
  Lisp_Object background;
  Lisp_Object cursor_foreground;
  Lisp_Object cursor_background;

  Lisp_Object stipple;		/* X-pixmap */
  Lisp_Object background_stipple;
  Lisp_Object cursor_stipple;

  Lisp_Object font;		/* pointer to X_font structure (font) */

  Lisp_Object underline;	/* underline color */

  Lisp_Object tag;		/* tag (symbol) */
#ifdef HAVE_GRAPHIC_ZONES
  Lisp_Object pixmap;
#endif
};

/* The various lisp support macros */

#define XBUTTON(a) ((struct Lisp_Button *) XPNTR(a))
#define XSTYLE(a) ((struct Lisp_Style *) XPNTR(a))

#define BUTTONP(a) ( XTYPE((a)) == Lisp_Button )
#define STYLEP(a) ( XTYPE((a)) == Lisp_Style )

extern Lisp_Object Qbuttonp;
extern Lisp_Object Qstylep;

#define CHECK_BUTTON(x, i) \
  { if (XTYPE((x)) != Lisp_Button) x = wrong_type_argument (Qbuttonp, (x)); }

#define CHECK_STYLE(x, i) \
  { if (XTYPE((x)) != Lisp_Style) x = wrong_type_argument (Qstylep, (x)); }

/* Interface to button routines and line-plotting routines */
extern Lisp_Object get_button();
extern Lisp_Object get_start_button();
extern struct Lisp_Style *find_style();
extern PlotTextLine();
extern InsertChar();
extern ShipOutTextBlock();
