;;; Copyright (C) 1990  Christopher J. Love
;;;
;;; This file is for use with Epoch, a modified version of GNU Emacs.
;;; Requires Epoch 3.2 or later.
;;;
;;; This code is distributed in the hope that it will be useful,
;;; bute WITHOUT ANY WARRANTY. No author or distributor accepts
;;; responsibility to anyone for the consequences of using this code
;;; or for whether it serves any particular purpose or works at all,
;;; unless explicitly stated in a written agreement.
;;;
;;; Everyone is granted permission to copy, modify and redistribute
;;; this code, but only under the conditions described in the
;;; GNU Emacs General Public License, except the original author nor his
;;; agents are bound by the License in their use of this code.
;;; (These special rights for the author in no way restrict the rights of
;;;  others given in the License or this prologue)
;;; A copy of this license is supposed to have been given to you along
;;; with Epoch so you can know your rights and responsibilities. 
;;; It should be in a file named COPYING.  Among other things, the
;;; copyright notice and this notice must be preserved on all copies. 
;;;

;;
;; menu.el - provide "standard" menu package for use with GWM.  This code
;;	     supports the proposed WM_MENU standard, under which X11 clients
;;	     can depend on window manager to provide a basic menu package.
;;
(provide 'menu)
(require 'mini-cl)
(require 'epoch-util)
(require 'event)
(require 'property)

(setq wm-menu (intern-atom "WM_MENU"))
(setq wm-menu-return (intern-atom "WM_MENU_RETURN"))

(defvar menu::selection nil
  "Most recent menu selection"
)
(defvar running-gwm (get-property "GWM_RUNNING" (car (query-tree)))
  "T if gwm is running"
)

;;
;; NOTE:  hacking the value of auto-raise-screen is an *extreme* hack,
;; 	  but was necessary to insure that all submenus, etc. are visible
;;	  over Epoch edit screens.  There should be another way to do this;
;;	  this should be fixed.
;;
;; menu::popup - given an alist containing menu options, produce a popup
;;		 menu with those options.  Return item associated with
;;		 the selected option (can be of any elisp type)
;;
;; menu format:
;; ("menu title"
;;    (return-symbol "option name")	; one option-list for each option
;;    ...
;; )
;; For sub-menus, option-list should contain a 3rd member:  an alist of
;; identical format.
;;
(defvar menu::returned-p nil)
(pop-property wm-menu-return)
(push-property wm-menu-return 'menu::handle-wm-return)
(defun menu::handle-wm-return (type value screen)
  (setq menu::returned-p t)
)

(defun menu::popup (menu)
  "Produce a popup menu with options described in MENU."
  (if (not running-gwm)
    (message "Menu package is only supported by GWM window manager")
    (setq menu::returned-p nil)
    (set-property wm-menu (prin1-to-string (menu::parse menu)))
    (sit-for 0)
    (while (not (or menu::returned-p (input-pending-p)))
      (message "Waiting for Menu")
      (sit-for 1)
    )
    (message "")
    (setq menu::selection (get-property wm-menu-return))
    (if (not (eq menu::selection 0))
      (setq menu::selection (menu::return menu::selection menu))
    )
  )
)

;;
;; menu::return - given the return string from GWM, return the user's
;;		  desired return value, which is contained in the menu alist
;;
(defun menu::return (ret-string menu-alist)
  (let
    (
      (pos (string-match "[.]" ret-string))
      (next (match-end 0))
    )
    (if pos
      (menu::return
	(substring ret-string next)
	(caddr (nth (string-to-int (substring ret-string 0 pos)) menu-alist))
      )
      (car (nth (string-to-int ret-string) menu-alist))
    )
  )
)

;;
;; menu::parse - parse the current contents of menu alist, and return
;;		 a string which can be passed to WM_MENU
;;
(defun menu::parse (alist)
  (let
    (
      (ret-list (list (car alist)))
      (ilist (cdr alist))
    )
    (dolist (cur ilist)
      (if (null (cddr cur))
	;; option
	(setq ret-list (cons (cadr cur) ret-list))
	;; submenu
	(setq ret-list (cons (menu::parse (caddr cur)) ret-list))
      )
    )
    (setq ret-list (reverse ret-list))
  )
)
