/* Epoch 4.0 - hook interface to redisplay algorithm.     
   terminal control module for terminals described by TERMCAP
   
   Copyright (C) 1985, 1986, 1987 Free Software Foundation, Inc.

This file is part of GNU Emacs.

GNU Emacs is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU Emacs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Emacs; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/*
 * $Revision: 1.13 $
 * $Source: /import/kaplan/stable/distrib/epoch-4.0p0/src/RCS/term.c,v $
 * $Date: 92/02/23 11:01:07 $
 * $Author: love $
 */
#ifndef LINT
static char rcsid[] = "$Author: love $ $Date: 92/02/23 11:01:07 $ $Source: /import/kaplan/stable/distrib/epoch-4.0p0/src/RCS/term.c,v $ $Revision: 1.13 $";
#endif

#include <stdio.h>
#include <ctype.h>
#include "config.h"
#include "termhooks.h"
#include "termchar.h"
#include "termopts.h"

#include "screen.h"		/* Epoch */
#include "screenW.h"		/* Epoch */
#include "dispepoch.h"		/* Epoch */

/* Hook functions that you can set to snap out the functions in this file.
   These are all extern'd in termhooks.h  */

int (*move_cursor_hook) ();

int (*clear_window_end_hook) ();
int (*clear_to_end_hook) ();
int (*clear_screen_hook) ();

int (*update_line_hook) ();
int (*insert_chars_hook) ();
int (*delete_chars_hook) ();
int (*shift_region_hook) ();

int (*ring_bell_hook) ();

int (*reset_terminal_modes_hook) ();
int (*set_terminal_modes_hook) ();
int (*update_begin_hook) ();
int (*update_end_hook) ();

int (*read_socket_hook) ();
int (*fix_screen_hook) ();

int (*text_width_hook) ();


int no_redraw_on_reenter;


/* text_width - return length (in pixels) of a string being displayed
 * 		in a given font.  If font is proportional, call the hook;
 * 		otherwise use local info from the font structure.
 */
short
text_width(font_struct,s,l)
     register struct X_font *font_struct;
     char *s;
     int l;
{
  int ret_val;
  if (text_width_hook)
    {
#ifdef HAVE_GRAPHIC_ZONES
      if (font_struct->virtual)
	return (short) XFWIDTH(font_struct) * l;
#endif
      if (!XFVARIABLE(font_struct))
	return (short) XFWIDTH(font_struct) * l;
      ret_val = (*text_width_hook) (font_struct->x_font,s,l);
      return (short) ret_val;
    }
  return l;
}

/*
 * ring_bell - ring a "bell" - visible or audible
 */
ring_bell ()
{
  if (ring_bell_hook)
    {
      (*ring_bell_hook) ();
      return;
    }
}

/*
 * set_terminal_modes - resets display information
 */
set_terminal_modes ()
{
  if (set_terminal_modes_hook)
    {
      (*set_terminal_modes_hook) ();
      return;
    }
}

/*
 * reset_terminal_modes - 
 */
reset_terminal_modes ()
{
  if (reset_terminal_modes_hook)
    {
      (*reset_terminal_modes_hook) ();
      return;
    }
}

/*
 * update_begin - do processing appropriate at start of redisplay
 * 		  process.  Code between update_begin and update_end is
 *	          considered atomic and *won't* be preemted
 */
update_begin ()
{
  if (update_begin_hook)
    (*update_begin_hook) ();
}

/*
 * update_end - do processing appropriate at end of redisplay process
 */
update_end ()
{
  if (update_end_hook)
    {
      (*update_end_hook) ();
      return;
    }
}

/*
 * move_cursor - move to absolute position, specified origin
 */
move_cursor (l,cb,row, col,win,rb)
     struct line_header *l;
     struct char_block *cb;
     int row,col;
     struct window *win;
     struct Root_Block *rb;
{
  if (move_cursor_hook)
    {
      (*move_cursor_hook) (l,cb,row,col,win,rb);
      return;
    }
}

/*
 * clear_screen - Clear entire screen
 */
clear_screen ()
{
  if (clear_screen_hook)
    {
      (*clear_screen_hook) ();
      return;
    }
}

/*
 * clear_window_end - Clear from last visible line on window to window
 *			end (presumably the line above window's modeline.
 */
clear_window_end (w,ystart,yend)
     struct window *w;
     int ystart,yend;
{
  if (clear_window_end_hook)
    {
      (*clear_window_end_hook) (w,ystart,yend);
      return;
    }
  /* Stuff goes here */
}

/*
 * update_line - Update a lines contents, changing from position CB to
 *		 position END, clearing end of line if CLEAR
 */
update_line(w,l,cb,end,clear)
     struct window *w;
     struct line_header *l;
     struct char_block *cb;
     struct char_block *end;
     char clear;
{
  if (update_line_hook)
    {
      (*update_line_hook) (w,l,cb,end,clear);
      return;
    }
  /* Stuff goes here */
}

/*
 * insert_chars - Do a fast insertion of a single char
 */
insert_chars (w,l,new,cb,end,clear)
     struct window *w;
     struct line_header *l;
     struct char_block *new,*cb,*end;
     char clear;
{
  register char *buf;
  register int c;
  int len;
  char *start;
  
  if (insert_chars_hook)
    {
      (*insert_chars_hook) (w,l,new,cb,end,clear);
      return;
    }
}

/*
 * delete_chars - Do a fast deletion of a single char (not used)
 */
delete_chars (n)
     register int n;
{
  char *buf;
  register int i;

  if (delete_chars_hook)
    {
      (*delete_chars_hook) (n);
      return;
    }
}

/*
 * shift_region - Shift a region between START and END to its new position
 */
shift_region(w,start,end)
     struct window *w;
     struct line_header *start,*end;
{
  if (shift_region_hook)
    {
      (*shift_region_hook) (w,start,end);
      return;
    }

  /* STUFF goes here */
}

/* VARARGS 1 */
fatal (str, arg1, arg2)
     char *str;
{
  fprintf (stderr, "emacs: ");
  fprintf (stderr, str, arg1, arg2);
  fflush (stderr);
  exit (1);
}
