;;; gwm-menus.el -*- emacs-lisp -*- Epoch support for simple GWM menus
;;; Original code by Colas 1991-02-18
;;; Heavily hacked by Dan Pierson, Encore Computer Corp, 2/28/91
;;; 	Explicity specify all Epoch commands in string passed to GWM
;;; 	Gratuitously reformat

;;;============================================================================
;;;                    Sane EPOCH_EXEC
;;;============================================================================

;;; here we add a handler to read code from X properties without trashing
;;; epoch in case of errors in sent code.

(defun epoch-exec::property-init ()
  "private property to avoid handler lost from external error"
  (push-property "EPOCH_EXEC"
		 (function (lambda (type prop screen)
		   (let ((cw (selected-window))
			 (action (get-property prop screen)))
		     (unwind-protect
			  (progn
			    (select-window (epoch::selected-window screen))
			    (and (stringp action)
				 (eval (read action))))
		       (select-window cw)))))))

(epoch-exec::property-init)

;;; use by sending to X property EPOCH_EXEC the code:
;;;      (let ((protect epoch::event-handler))
;;;        (unwind-protect
;;; 	     (progn 
;;; 
;;; 	       ... [code to excecute via the property] ...
;;; 
;;; 	       (setq epoch::event-handler protect))))
;;; 

;;; General menu popper, expects a list of the form:
;;; 	'("Title"
;;;       ("Item" epoch-code)
;;;       ...)

(defun gwm-pop-menu (items)
  (epoch::set-property "GWM_EXECUTE"
			 (concat "(progn (require 'epoch)(list-menu-make "
				 (prin1-to-string items)
				 "))"
				 )))

;;; Application: pop a menu with epoch buffers:

(defun gwm-choose-buffer (arg)
  (let ((buflist (cons "Epoch Screens"
		       (mapcar (function (lambda (buf)
				 (let ((name (buffer-name buf)))
				   (list name
					 'switch-to-buffer
					 (concat "\"" name "\"")))))
			       (buffer-list)))))
    (gwm-pop-menu buflist)))

(global-set-mouse mouse-right mouse-control-shift 'gwm-choose-buffer)
