;;; Copyright (C) 1991 Christopher J. Love
;;;
;;; This file is for use with Epoch, a modified version of GNU Emacs.
;;; Requires Epoch 4.0 or later.
;;;
;;; This code is distributed in the hope that it will be useful,
;;; bute WITHOUT ANY WARRANTY. No author or distributor accepts
;;; responsibility to anyone for the consequences of using this code
;;; or for whether it serves any particular purpose or works at all,
;;; unless explicitly stated in a written agreement.
;;;
;;; Everyone is granted permission to copy, modify and redistribute
;;; this code, but only under the conditions described in the
;;; GNU Emacs General Public License, except the original author nor his
;;; agents are bound by the License in their use of this code.
;;; (These special rights for the author in no way restrict the rights of
;;;  others given in the License or this prologue)
;;; A copy of this license is supposed to have been given to you along
;;; with Epoch so you can know your rights and responsibilities. 
;;; It should be in a file named COPYING.  Among other things, the
;;; copyright notice and this notice must be preserved on all copies. 
;;;
;;; graphic.el - demonstrate graphic button capabilities.
;;;
;;; NOTE:  You will need to adjust the directory mentioned to give the full
;;; path name to this file (and the NeXT.xpm file).
;;;
;;;                                                            |
;;; Previous line is position where graphic buttons will be inserted
;;;
;;; Evaluate following s-expr to create a graphical button:
;;;
(if (null (functionp 'add-graphic-zone))
  (message "Requires graphical button option - see config.h")
  (progn
    (if (null (add-graphic-zone "/home/kaplan/love/epoch/contrib/love/NeXT.xpm"
	  1347 1348 50))
      (message "Check the location of NeXT.xpm file")
)))

;;;
;;; The add-graphic-zone primitive is equivalent to the following elisp
;;; code: (which loads the pixmap file each time executed)

;; Load pixmap file (if found)
(setq pix (epoch::read-pixmap-file "/epoch-4.0/contrib/love/NeXT.xpm"))
(if (null pix)
  (message "Check location of pixmap file")
  (progn
    (setq s (make-style))
    (setq dim (query-pixmap pix))
    (setq fname (epoch::define-opaque-font      	; Generate unique name 
	(concat "F" (car dim) "x" (cadr dim) 50)	; based on dimensions
	(car dim) (cadr dim) 50
    ))
    (set-style-font s fname)
    (epoch::set-style-pixmap s pix)
    (setq b (add-zone 1347 1348 s))
))
