;; GNU Emacs commands to drag objects.

(provide 'drag)
(require 'cl)

(defun move-modeline-up (arg)
  "Moves the modeline of the current window up by ARG lines.
The text of the all windows stays in place, minimizing screen update.
Default is 1 line, negative ARG moves down."
  (interactive "p")
  (shrink-window arg)
  (let ((current-window (selected-window)))
    ;; If more than one window visible,
    ;; don't scroll the text in the other windows.
    ;; This doesn't work for horizontal windows.
    (eval-in-window (next-window current-window nil)
		    (if (not (equal current-window (selected-window)))
			(scroll-down arg)))))

(defun move-window-up (&optional window arg)
  "Moves the given WINDOW up by ARG windows, keeping window sizes constant.
WINDOW defaults to the selected one and ARG defaults to one.  Negative
arguments moves down."
  (interactive)
  (if (null window)
      (setq window (selected-window)))
  (if (or (null arg) (= arg 0))
      (setq arg 1))

  (let (other-window
	(this-window-buffer (window-buffer window))
	(this-window-hscroll (window-hscroll window))
	(this-window-point (window-point window))
	(this-window-start (window-start window))
	(this-window-height (window-height window)))

    (while (/= arg 0)
      (if (> arg 0)
	  (progn
	    (decf arg)
	    (setq other-window (previous-window window)))
	(progn
	  (incf arg)
	  (setq other-window (next-window window))))
      (let ((other-window-buffer (window-buffer other-window))
	    (other-window-hscroll (window-hscroll other-window))
	    (other-window-point (window-point other-window))
	    (other-window-start (window-start other-window))
	    (other-window-height (window-height other-window)))

	(set-window-buffer window other-window-buffer)
	(set-window-hscroll window other-window-hscroll)
	(set-window-point window other-window-point)
	(set-window-start window other-window-start)

	(select-window window)
	(shrink-window (- (window-height nil) other-window-height))
	(setq window other-window)
	)
      )

    (set-window-buffer other-window this-window-buffer)
    (set-window-hscroll other-window this-window-hscroll)
    (set-window-point other-window this-window-point)
    (set-window-start other-window this-window-start)

    (select-window other-window)
    (shrink-window (- (window-height nil) this-window-height)))
  )
