/*
 * This once was req.c by Markus Wandel. It doesn't look too much like the
 * original version though... Well, it was PD, I used it, so here is his
 * original disclaimer:
 *
 * req.c - by Markus Wandel - 1990
 * Placed in the public domain 7 Oct 1990
 * Please have the courtesy to give credit if you use this code
 * in any program.
 *
 */
#include <exec/types.h>
#include <intuition/intuition.h>

#define BASE_EXT_DECL
#define BASE_PAR_DECL struct IntuitionBase *IntuitionBase,
#define BASE_PAR_DECL0 struct IntuitionBase *IntuitionBase
#include <inline/intuition.h>

#include <inline/exec.h>

int
__request_msg (const char *msg, const char *button)
{
  struct IntuiText line, righttext;
  struct IntuitionBase *IntuitionBase;
  int result;

  /* we (re)open intuition, because that way we don't depend on arp.library
   * being available for us to open intuibase */

  if (IntuitionBase = (struct IntuitionBase *)OpenLibrary("intuition.library",0))
    {
      line.FrontPen = AUTOFRONTPEN;
      line.BackPen = AUTOBACKPEN;
      line.DrawMode = AUTODRAWMODE;
      line.ITextFont = AUTOITEXTFONT;
      line.NextText = 0;
      CopyMem(&line, &righttext, sizeof(line));
      righttext.LeftEdge = AUTOLEFTEDGE;
      righttext.TopEdge = AUTOTOPEDGE;
      line.LeftEdge = 15;
      line.TopEdge = 5;

      line.IText = (UBYTE *) msg;
      righttext.IText = (UBYTE *) button;
      result = AutoRequest(IntuitionBase,0L,&line,0L,&righttext,0L,0L,320L,72L);
      CloseLibrary(IntuitionBase);
      return result;
   }
 return -1;
}
