#!/bin/bash

CURDIR=$(dirname "$(realpath "${BASH_SOURCE[0]}")")

mkdir -p data/locale

xgettext --from-code=UTF-8                                  \
         --language=Python                                  \
         --no-location                                      \
         --keyword=N_                                       \
         --output-dir=data/locale                           \
         --output=mygnuhealth.pot *.py ui/*.kv

for lang in en fr de es zh_CN
do
    lang_dir=${CURDIR}/data/locale/${lang}/LC_MESSAGES/
    mkdir -p ${lang_dir}
    cd ${lang_dir}

    if [ -f "mygnuhealth.po" ]; then
        msgmerge --quiet --update --backup=none     \
                 mygnuhealth.po ../../mygnuhealth.pot

        msgattrib --no-obsolete mygnuhealth.po        \
                  --output-file mygnuhealth.po
    else
        msginit --input=../../mygnuhealth.pot         \
                --output-file=mygnuhealth.po          \
                --no-translator                     \
                --locale=${lang}.UTF-8
    fi

    msgfmt mygnuhealth.po -o mygnuhealth.mo

done

