# Generated by Django 3.0.2 on 2020-01-21 15:47

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import talerbank.app.models
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="BankAccount",
            fields=[
                ("is_public", models.BooleanField(default=False)),
                ("account_no", models.AutoField(primary_key=True, serialize=False)),
                (
                    "balance",
                    talerbank.app.models.SignedAmountField(
                        default=talerbank.app.models.get_zero_signed_amount
                    ),
                ),
                (
                    "user",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="TalerWithdrawOperation",
            fields=[
                (
                    "withdraw_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("amount", talerbank.app.models.AmountField(default=False)),
                ("selection_done", models.BooleanField(default=False)),
                ("confirmation_done", models.BooleanField(default=False)),
                ("aborted", models.BooleanField(default=False)),
                ("selected_reserve_pub", models.TextField(null=True)),
                (
                    "selected_exchange_account",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="selected_exchange_account",
                        to="app.BankAccount",
                    ),
                ),
                (
                    "withdraw_account",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="withdraw_account",
                        to="app.BankAccount",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="BankTransaction",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("amount", talerbank.app.models.AmountField(default=False)),
                (
                    "subject",
                    models.CharField(default="(no subject given)", max_length=200),
                ),
                ("date", models.DateTimeField(auto_now=True, db_index=True)),
                ("cancelled", models.BooleanField(default=False)),
                ("request_uid", models.CharField(max_length=128, unique=True)),
                (
                    "credit_account",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="credit_account",
                        to="app.BankAccount",
                    ),
                ),
                (
                    "debit_account",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="debit_account",
                        to="app.BankAccount",
                    ),
                ),
            ],
        ),
    ]
