/* -*- mode: c++ -*- 
*/
/* 

    GIFT, a flexible content based image retrieval system.
    Copyright (C) 1998, 1999, 2000 CUI, University of Geneva

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
// -*- mode: c++ -*-
#ifndef _CACCESSORFACTORYCONTAINER
#define _CACCESSORFACTORYCONTAINER

#include <map>
#include <string>

class CXMLElement;
class CAccessor;
class CAccessorFactory;
/**
 * This is destined to hold a number of CAccessorFactories.
 * The use of this is to have an open-close-counter for 
 * all the factories which have been registered in this
 * 
 * New elements are only constructed if necessary.
 *
 *@author Wolfgang Mller
 */
class CAccessorFactoryContainer{
  /** 
      This tree contains the configuration data for this
  */
  const CXMLElement* mConfigurationData;
  /**
     Content is pointer to a factory,
     a pointer to the actual Accessor (if already made)
     and the open-close-counter
   */
  class CContentElement{
  public:
    /** Contains a pointer to the accessor, if already opened */
    CAccessor* mAccessor;
    /** The factory to make an accessor, if this is needed */
    CAccessorFactory* mFactory;
    /** Counts how often the accessor has been opened or closed */
    int mOpenCloseCounter;
  };
  /** 
      Typedef: The content is a map of string to content element 
   */
  typedef map<string,CContentElement> CContent;
  /** The content is a map of string to content element */
  CContent mContent;
 public:
  /** configure this */
  void configure(const CXMLElement* inConfigurationData);
  /**
     The destructor destroys the CContentElements properly 
  */
  ~CAccessorFactoryContainer();
  /** 
      adding a factory to the content
   */
  void registerFactory(CAccessorFactory* inFactory,
		       string inName);
  /**
     opening an accessor:
     if the accessor is already constructed,
     then simply give the pointer,
     otherwhise construct a new one 
     using the appropriate factory

  */
  CAccessor* openAccessor(string inName);
  /**
     closing an accessor.
     If there have been as many openAccessor 
     as closeAccessor calls, the accessor will
     be delete-d.
  */
  void closeAccessor(string inName);
  
};

#endif
