// -*- mode: c++ -*- 
/* 

    GIFT, a flexible content based image retrieval system.
    Copyright (C) 1998, 1999, 2000 CUI, University of Geneva

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "mrml_const.h" // for parsing
#include "CXMLElement.h" // mCollectionElement 
#include "CXMLHelper.h"

#include "CAccessorProxy.h"

#include "CAFInvertedFile.h"
#include "CAFIFMySQL.h"
#include "CAFPerl.h"
#include "CAFURL2FTS.h"
#include "CAFDistanceMatrix.h"
#include "CAFHierarchy.h"
///
void CAccessorProxy::setCollectionElement(CXMLElement* inElement){
  mCollectionElement=inElement;
    mFactoryContainer.configure(inElement);
};
///
const CXMLElement* CAccessorProxy::getCollectionElement()const{
  return mCollectionElement;
};
///
CAccessorProxy::CAccessorProxy():
  mFactoryContainer(){
  (new CAFInvertedFile())->registerFactory(mFactoryContainer);
#ifdef __GIFT_BAYESIAN__
  (new CAFDistanceMatrix())->registerFactory(mFactoryContainer);
#endif
#ifdef __GIFT_WITH_MYSQL__
  (new CAFIFMySQL())->registerFactory(mFactoryContainer);
#endif
#ifdef __GIFT_WITH_PERL__
  (new CAFPerl())->registerFactory(mFactoryContainer);
#endif
  (new CAFURL2FTS())->registerFactory(mFactoryContainer);
  (new CAFHierarchy())->registerFactory(mFactoryContainer);
};
///
CAccessor* CAccessorProxy::openAccessor(string inName){  
  return mFactoryContainer.openAccessor(inName);
};
///
void CAccessorProxy::closeAccessor(string inName){
  mFactoryContainer.closeAccessor(inName);
};
///
string CAccessorProxy::toXML(bool isPrivate)const{

  CXMLHelper lHelper;

  lHelper.setName(mrml_const::collection);
  lHelper.setEmpty();
  lHelper.addAttribute(mrml_const::collection_id,mCollectionElement->stringReadAttribute(mrml_const::collection_id).second);
  lHelper.addAttribute(mrml_const::collection_name,mCollectionElement->stringReadAttribute(mrml_const::collection_name).second);
  lHelper.addAttribute(mrml_const::cui_algorithm_id_list_id,getAlgorithmIDListID());
  

  string lReturnValue=lHelper.toString();
  return lReturnValue;
}

///
CXMLElement* CAccessorProxy::toXMLElement()const{
  CXMLElement* lReturnValue(0);

  if(mCollectionElement){
    lReturnValue=new CXMLElement(*mCollectionElement);
  }

  return lReturnValue;
}

string CAccessorProxy::getAlgorithmIDListID()const{
  return mCollectionElement->stringReadAttribute(mrml_const::cui_algorithm_id_list_id).second;
}
string CAccessorProxy::getName()const{
  return mCollectionElement->stringReadAttribute(mrml_const::collection_name).second;
}
string CAccessorProxy::getID()const{
  return mCollectionElement->stringReadAttribute(mrml_const::collection_id).second;
}

/** */
list<string>* CAccessorProxy::getAvailableIndices()const{
  list<string>* lReturnValue=new list<string>();

  lReturnValue->push_back("inverted_file");

  return lReturnValue;
};

///
bool CSortByName_pAP::operator()(const CAccessorProxy* l,
				 const CAccessorProxy* t){
    return 
      l->mCollectionElement->stringReadAttribute(mrml_const::collection_name).second
      <
      t->mCollectionElement->stringReadAttribute(mrml_const::collection_name).second;
}
			    
