/*
 * Electric(tm) VLSI Design System
 *
 * File: config.h
 * Site-dependent definitions
 * Written by: Steven M. Rubin, Static Free Software
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

#ifndef _CONFIG_H_
#define _CONFIG_H_ 1

/********************* MACHINE DETERMINATION *********************/

/* determine if it is Macintosh OS */
#if defined(THINK_C) || defined(THINK_CPLUS) || defined(__MWERKS__)
#  define MACOS 1
#endif

/* determine if it is Windows 9x/NT */
#if (defined(_WIN32) || defined(__WIN32__)) && !defined(WIN32)
#  define WIN32 1
#endif

/* determine if it is UNIX */
#if !defined(MACOS) && !defined(WIN32)
#  define ONUNIX 1
#endif

/********************* MACHINE-SPECIFIC DEFINES *********************/

#ifdef	MACOS						/***** Macintosh *****/
#  include <QDOffscreen.h>
#  define STDC_HEADERS     1
#  define DIRSEP           ':'						/* directory separator */
#  define NONFILECH        '|'						/* character that cannot be in file name */
#  define CADRCFILENAME    "cadrc"					/* CAD startup file */
#  define LIBDIR           ":lib:"					/* location of library files */
#  define ESIMLOC          ""
#  define RSIMLOC          ""
#  define PRESIMLOC        ""
#  define RNLLOC           ""
#  define SPICELOC         ""
#  define FASTHENRYLOC     ""
#  define SORTLOC          ""
#  define FLATDRCLOC       ""
#  define SFLATDRCLOC      ""
#endif

#ifdef WIN32						/***** Windows *****/
#  include "windows.h"
#  define STDC_HEADERS     1
#  define DIRSEP           '\\'						/* directory separator */
#  define NONFILECH        '|'						/* character that cannot be in file name */
#  define CADRCFILENAME    "cadrc"					/* CAD startup file */
#  define LIBDIR           "lib\\"					/* location of library files */
#  define ESIMLOC          ""
#  define RSIMLOC          ""
#  define PRESIMLOC        ""
#  define RNLLOC           ""
#  define SPICELOC         ""
#  define FASTHENRYLOC     ""
#  define SORTLOC          ""
#  define FLATDRCLOC       ""
#  define SFLATDRCLOC      ""
#  undef TECHNOLOGY
#endif

#ifdef ONUNIX						/***** UNIX *****/
#  include "defines.h"
#  include <X11/Intrinsic.h>
#  define DIRSEP           '/'						/* directory separator */
#  define NONFILECH        '?'						/* character that cannot be in file name */
#  define CADRCFILENAME    ".cadrc"					/* CAD startup file */
#  define LIBDIR           "lib/"					/* location of library files */
#  define ESIMLOC          "/usr/local/bin/esim"
#  define RSIMLOC          "/usr/local/bin/rsim"
#  define PRESIMLOC        "/usr/local/bin/presim"
#  define RNLLOC           "/usr/local/bin/rnl"
#  define SPICELOC         "/usr/local/bin/spice"
#  define FASTHENRYLOC     "/usr/local/bin/fasthenry"
#  define SORTLOC          "/usr/bin/sort"
#  define FLATDRCLOC       "/usr/local/bin/ffindshort"
#  define SFLATDRCLOC      "/usr/local/bin/findshort"
#endif

/********************* SOURCE MODULE CONFIGURATION *********************/

/* The tools (User and I/O are always enabled) */
#define COMAID             1
#define COMPENAID          1
#define DRCAID             1
#define ERCAID             1
#define LOGEFFAID          1
#define MAPPERAID          0
#define PLAAID             1
#define PROJECTAID         1
#define ROUTAID            1
#define SCAID              1
#define SIMAID             1
#define VHDLAID            1

/* The I/O modules (Binary, Text, and printer formats are always enabled) */
#define IOCIF              1
#define IODEF              1
#define IODXF              1
#define IOEAGLE            1
#define IOEDIF             1
#define IOGDS              1
#define IOL                1
#define IOLEF              1
#define IOPADS             1
#define IOSDF              1
#define IOSKILL            FORCECADENCE
#define IOSUE              1

/* The technologies (Artwork, Generic and Schematic are always enabled) */
#define TECBICMOS          1
#define TECBIPOLAR         1
#define TECCMOS            1
#define TECCMOSDODN        1
#define TECEFIDO           1
#define TECFPGA            1
#define TECGEM             1
#define TECMOCMOS          1
#define TECMOCMOSSUB       1
#define TECMOCMOS2         1
#define TECNMOS            1
#define TECPCB             1
#define TECRCMOS           1

/* The language interfaces */
#define LANGJAVA           FORCEJAVA
#define LANGLISP           FORCELISP
#define LANGTCL            FORCETCL

#endif  /* _CONFIG_H_ - at top */
