/* Driver routine to print the results from AE address trace to stdout.
   Copyright (C) 1989, 1990 by James R. Larus (larus@cs.wisc.edu)

   AE and AEC are free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 1, or (at your option) any
   later version.

   AE and AEC are distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU CC; see the file COPYING.  If not, write to James R.
   Larus, Computer Sciences Department, University of Wisconsin--Madison,
   1210 West Dayton Street, Madison, WI 53706, USA or to the Free
   Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */

/* $Header: /var/home/larus/AE/AEC/RCS/adtr.c,v 2.0 90/02/09 17:23:35 larus Exp Locker: larus $ */


#include <stdio.h>
#include "aec.h"


void reference ();

static int no_output = 0;	/* Print references? */
static int loop_info = 0;	/* Print loop info? */

static int num_inst = 0;
static int num_ref = 0;


main (argc, argv)
     int argc;
     char *argv[];
{
  no_output = (argc > 2);
  if (argc > 2 && *argv[2] == 'l')
    loop_info = 1, no_output = 0;

  ae_recreate (argv[1], reference);
  fprintf (stderr, "%d instructions, %d memory references = %d\n", num_inst,
	   num_ref, num_inst + num_ref);
}


void
reference (type, addr, n_inst)
     int type;
     int addr;
     int n_inst;
{
  switch (type)
    {
    case INST_REF:
      num_inst += n_inst;
      if (!no_output) printf ("I x %d: %x\n", n_inst, addr);
      break;

    case MEM_READ:
      num_ref ++;
      if (!no_output) printf ("R: %x\n", addr);
      break;

    case MEM_WRITE:
      num_ref ++;
      if (!no_output) printf ("W: %x\n", addr);
      break;

    case START_LOOP:
      if (!no_output && loop_info) printf("SL: %d\n", addr);
      break;

    case CONT_LOOP:
      if (!no_output && loop_info) printf("CL: %d\n", addr);
      break;

    case END_LOOP:
      if (!no_output && loop_info) printf("EL: %d\n", addr);
      break;

    default:
      if (!no_output) printf ("?: %x\n", addr);
      break;
    }
}

